package com.soss.common.enums;

/**
 * 店铺状态枚举类
 */
public enum ShopState {
    TESTING(0, "测试中"),
    OPEN(1, "正常营业"),
    CLOSE(2, "暂停营业"),
    DELETE(3, "已关闭");

    private Integer state;
    private String desc;

    ShopState(Integer state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public Integer getState() {
        return state;
    }

    public static String getDesc(Integer state) {
        for (ShopState categoryType : ShopState.values()) {
            if (categoryType.state.equals(state)) {
                return categoryType.desc;
            }
        }
        return null;
    }
}
