package com.soss.system.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;

/**
 * 订单快照对象 order_snapshot
 * 
 * @author zxq
 * @date 2022-05-22
 */
@Data
public class OrderSnapshot extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long orderId;

    /** 快照数据 */
    @Excel(name = "快照数据")
    private String snapshot;

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("orderId", getOrderId())
            .append("snapshot", getSnapshot())
            .toString();
    }
}
