package com.soss.system.service;

import com.soss.system.domain.SysBanner;
import com.soss.system.domain.po.BannerListPo;
import com.soss.system.domain.po.BannerPo;
import com.soss.system.domain.vo.BannerVo;

import java.util.List;

/**
 * 轮播图Service接口
 *
 * @author zxq
 * @date 2022-04-28
 */
public interface ISysBannerService {
    List<SysBanner> selectBanner(BannerListPo banner);

    Long createBanner(BannerPo banner);

    Boolean updateBanner(BannerPo banner);

    Boolean updateState(Long bannerId, Integer state);

    Boolean delete(Long bannerId);

    List<BannerVo> copyBanner(List<SysBanner> banners);
    void translateArea(List<BannerVo> bannerVos);

    List<SysBanner> getBannersByShopId(Long shopId, Integer type, Integer target);
    List<String> getKDSBannerByShopId(Long shopId);
}
