package com.soss.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.soss.common.exception.ServiceException;
import com.soss.common.utils.DateUtils;
import com.soss.common.utils.StringUtils;
import com.soss.system.constants.OrderStatusConstant;
import com.soss.system.domain.*;
import com.soss.system.domain.vo.ResultVo;
import com.soss.system.jiguang.impl.JiGuangPushServiceImpl;
import com.soss.system.mapper.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import java.util.*;

@Service
@Slf4j
public class MachineApiServiceImpl {
    @Autowired
    private ShopGoodsMapper shopGoodsMapper;
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private ShopGoodsSkuMapper shopGoodsSkuMapper;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Value("${machine.url}")
    private String url;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MachineMapper machineMapper;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private JiGuangPushServiceImpl jiGuangPushService;
    @Autowired
    private OrderOperationLogServiceImpl operationLogService;

    public String shopGoodsUpdate(JSONObject jsonObject) {
        String shopID = jsonObject.getString("shopId");
        String skuIDs = jsonObject.getString("skuId");
        List<String> skuIds = JSONObject.parseArray(skuIDs, String.class);
        String robotID = jsonObject.getString("robotId");
        String status = jsonObject.getString("status");
        if(StringUtils.isEmpty(skuIDs)){
            throw new ServiceException("sku不能为空");
        }
        ShopGoodsSku shopGoodsSku = new ShopGoodsSku();
        shopGoodsSku.setShopId(Long.parseLong(shopID));
        Map<Long,List<Long>> map = new HashMap<>();
        for (String skuId : skuIds) {
            shopGoodsSku.setSkuId(Long.parseLong(skuId));
            List<ShopGoodsSku> shopGoodsSkus = shopGoodsSkuMapper.selectShopGoodsSkuList(shopGoodsSku);
            if(CollectionUtils.isEmpty(shopGoodsSkus)){
                log.info(skuId+"不存在");
                continue;
//                throw new ServiceException(skuId+"不存在");
            }
            for (ShopGoodsSku goodsSkus : shopGoodsSkus) {
                Long goodsId = goodsSkus.getGoodsId();
                List<Long> strings = map.get(goodsId);
                if(strings ==null){
                    strings = new ArrayList<>();
                }
                strings.add(goodsSkus.getSkuId());
                map.put(goodsId,strings);
            }
        }
        int i = shopGoodsSkuMapper.updateSkuStatus(skuIds, robotID, shopID, status);
        //推送给极光
        Machine machine = machineMapper.selectMachineById(robotID);

        this.push(machine, status, map);
        return ""+i;

    }

    /**
     * {
     *     "action": "SKU_STATE_CHANGED",
     *     "timestamp": 1390010203013,
     *     "data": {
     *         "machineCode": "SN010293123",
     *         "goodsId": 100,
     *         "skuIds": [
     *             200,
     *             300
     *         ],
     *         "state": 2
     *     }
     * }
     * @param machine
     * @param status
     * @param map
     */

    public void push(Machine machine, String status, Map<Long, List<Long>> map) {
        for (Long aLong : map.keySet()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("action", "SKU_STATE_CHANGED");
            jsonObject.put("timestamp", System.currentTimeMillis());
            JSONObject data = new JSONObject();
            jsonObject.put("data", data);
            data.put("machineCode", machine.getCode());
            data.put("goodsId", aLong);
            data.put("skuIds", map.get(aLong));
            data.put("state", status);
            int machineId = Integer.parseInt(machine.getId());
            jiGuangPushService.push(machineId, null, jsonObject);
        }
    }

    public String updateOrder(JSONObject jsonObject) {
        Long orderID = jsonObject.getLong("orderId");
        String status = jsonObject.getString("status");
        Order order1 = orderService.selectById(orderID);
        if(order1==null){
            throw new ServiceException("该订单不存在");
        }

        order1.setState(status);
        order1.setUpdatedAt(new Date());
        if(OrderStatusConstant.completed.equals(status)){
            order1.setFinishTime(new Date());
        }
        int i = orderService.updateOrder(order1);

        return i+"";
    }

    public void testOrder(Long orderId) {
        try{
            if(orderId == null){
                orderId = 8L;
            }
            Order order = orderService.selectById(orderId);
            OrderDetail orderDetail =new OrderDetail();
            orderDetail.setOrderId(order.getId());
            List<OrderDetail> orderDetails = orderDetailMapper.selectOrderDetailList(orderDetail);
            for (OrderDetail detail : orderDetails) {
                Goods goods = goodsMapper.selectGoodsById(detail.getGoodsId());
                detail.setGoods(goods);
            }
            order.setOrderDetails(orderDetails);
           createOrder(order);
        }catch (Exception e){
            log.error("",e);
        }

    }

    public ResultVo createOrder(Order order){
        String orderInfo = null;
        JSONObject orderJson =null;
        try{
            ObjectMapper objectMapper = new ObjectMapper();
            orderInfo = objectMapper.writeValueAsString(order);
            log.info("创建订单数据为：【{}】",orderInfo);
            orderJson = JSONObject.parseObject(orderInfo);
            orderJson.put("goodsNum",orderJson.getLong("goodsNum"));
            orderJson.put("machineId",orderJson.getLong("machineId"));
            orderJson.put("shopId",orderJson.getLong("shopId"));
            orderJson.put("state",orderJson.getLong("state"));
            List<JSONObject> goodsList =new ArrayList<>();
            orderJson.put("goodsList",goodsList);
            List<OrderDetail> orderDetails = order.getOrderDetails();
            for (OrderDetail detail : orderDetails) {
                JSONObject jsonObject = new JSONObject();
                goodsList.add(jsonObject);
                jsonObject.put("goodsId", detail.getGoodsId());
                jsonObject.put("goodsName", detail.getGoodsName());
                jsonObject.put("num", detail.getNum());
                jsonObject.put("amount", detail.getOriAmount());
                jsonObject.put("specRuleDetail", detail.getSpecRuleDetail());
                jsonObject.put("specRuleIds", detail.getSpecRuleIds());
                jsonObject.put("skuId", detail.getSkuId());
//                if("0".equals(detail.getGoodsCategory())){
//                    jsonObject.put("goodsCategory","今日特惠");
//                }else{
//                    GoodsCategory goodsCategory = goodsCategoryMapper.selectGoodsCategoryById(detail.getGoodsCategory());
//                    jsonObject.put("goodsCategory",goodsCategory.getName());
//                }

            }
        }catch (Exception e){
            log.error("初始化订单发生异常",e);
            throw new ServiceException("初始订单数据异常，请重试");
        }

        ResultVo resultVo =sendRequest(orderJson.toJSONString(),"/v1/order");

        String code = resultVo.getCode();
        if("2001".equals(code)){
            throw  new ServiceException("库存不足");
        }else   if("3001".equals(code)){
            throw  new ServiceException("机器繁忙");
        }
        return resultVo;

    }




    public ResultVo sendRequest(String  param,String interfaceName){
        try{
            String postUrl = url+interfaceName;
            log.info("请求订单接口[{}]：【{}】",postUrl,param);
            HttpHeaders requestHeaders = new HttpHeaders();
            requestHeaders.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity(param,requestHeaders);
            JSONObject.toJSONString(param);
            ResponseEntity<String> stringResponseEntity = restTemplate.postForEntity(postUrl, requestEntity, String.class);
            log.info("请求接口返回结果为[{}]：【{}】",postUrl,stringResponseEntity.getBody());
            ResultVo resultVo = JSONObject.parseObject(stringResponseEntity.getBody(), ResultVo.class);
            return resultVo;
        }catch (Exception e){
            log.error("请求发生异常：",e);
            throw  new ServiceException("服务器繁忙，请重试");
        }

    }

    public void testOrderUpdate(String orderId) {
        if(StringUtils.isEmpty(orderId)){
            orderId = "8";
        }
        JSONObject param = new JSONObject();
        JSONObject data = new JSONObject();
        data.put("state",2);
        data.put("payTime",new Date());
        param.put("data",data.toJSONString());
        param.put("orderId",orderId);
        sendRequest(param.toJSONString(),"/v1/order/update");
    }

    public Object robotUpdate(JSONObject jsonObject) {
        String robotID = jsonObject.getString("robotId");
        Integer status = jsonObject.getInteger("status");
        Long shopID = jsonObject.getLong("shopId");
        Machine machine = new Machine();
        machine.setShopId(shopID);
        machine.setId(robotID);
        List<Machine> machines = machineMapper.selectMachineList(machine);
        if(machines.isEmpty()){
            throw new ServiceException("该机器未绑定店铺") ;
        }
        machine.setState(status);
        return machineMapper.updateMachine(machine);
    }

    public void updateOrder(Order order) {
        JSONObject param = new JSONObject();
        JSONObject data = new JSONObject();
        data.put("state",Integer.parseInt(order.getState()));
        if (Objects.equals(OrderStatusConstant.Paid, order.getState())) {
            data.put("payTime", DateUtils.parseDateToStr("yyyy-MM-dd HH:mm:ss", order.getPayTime()));
        }
        param.put("data",data.toJSONString());
        param.put("orderId",order.getId());
        ResultVo resultVo = sendRequest(param.toJSONString(), "/v1/order/update");
        operationLogService.insertOrderOperationLog(order,resultVo);

    }

    public Object checkOrder(JSONObject jsonObject) {
        String orderId = jsonObject.getString("orderId");
        String secret = jsonObject.getString("secret");
        String value = stringRedisTemplate.opsForValue().get(secret);
        if(value ==null){
            throw new ServiceException("该密钥错误或者已经失效");
        }
        if(orderId.equals(value)){
            throw new ServiceException("密钥获取订单失败");
        }
        return null;

    }
}
