package com.soss.web.controller.coffee;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.core.domain.model.LoginUser;
import com.soss.common.core.page.TableDataInfo;
import com.soss.common.exception.ServiceException;
import com.soss.common.utils.StringUtils;
import com.soss.framework.web.service.TokenService;
import com.soss.system.domain.Order;
import com.soss.system.domain.OrderDetail;
import com.soss.system.domain.vo.CouponVo;
import com.soss.system.service.ICouponRuleService;
import com.soss.system.service.ICouponUserService;
import com.soss.system.service.impl.OrderServiceImpl;
import com.soss.system.service.impl.WechatMessageServiceImpl;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/app")
public class AppController extends BaseController {
    @Autowired
    private TokenService tokenService;
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private WechatMessageServiceImpl wechatMessageService;
    @Autowired
    private ICouponUserService couponUserService;
    @Autowired
    private ICouponRuleService couponRuleService;

    @RequestMapping("/getMyOrder")
    public TableDataInfo getMyOrder(HttpServletRequest request) {
        LoginUser loginUser = tokenService.getLoginUser(request);
        if (loginUser == null) {
            throw new ServiceException("请先登录");
        }
        String openId = loginUser.getOpenId();
        startPage();
        List<Order> myOrder = orderService.getMyOrder(openId);
        orderService.wrapperOrder(myOrder, true);
        myOrder.forEach(order -> orderService.wrapperOrderDetailForApplet(order));
        return getDataTable(myOrder);
    }

    @RequestMapping("/getHomeOrder")
    public AjaxResult getHomeOrder(HttpServletRequest request,String shopId){
        LoginUser loginUser = tokenService.getLoginUser(request);
        if(loginUser ==null){
            return  AjaxResult.success();
        }
        String openId = loginUser.getOpenId();
        Map<String,String> info = orderService.getMyFristOrder(openId,shopId);
        return AjaxResult.success("操作成功",info);
    }

    @RequestMapping("/getWaitTine")
    public AjaxResult getWaitTime(@RequestBody String body){
        JSONObject jsonObject = JSONObject.parseObject(body);
        Order order = new Order();
        order.setShopId(jsonObject.getLong("shopId"));
        JSONArray goods = jsonObject.getJSONArray("goods");
        List<OrderDetail> orderDetails = new ArrayList<>();
        order.setOrderDetails(orderDetails);
        for (int i = 0; i < goods.size(); i++) {
            OrderDetail orderDetail = new OrderDetail();
            orderDetail.setGoodsId(goods.getJSONObject(i).getLong("goodsId"));
            orderDetail.setNum(goods.getJSONObject(i).getInteger("num"));
            orderDetails.add(orderDetail);
        }
        int waitTime = orderService.getWaitTime(order);
        return AjaxResult.success("操作成功", waitTime);
    }

    @RequestMapping("/getWaitTineByOrderId")
    public AjaxResult getWaitTineByOrderId( Long orderId){
        String info = orderService.getWaitTimeByOrderId(orderId);
        return AjaxResult.success("操作成功",info);
    }

    @RequestMapping("/refundOrder")
    public AjaxResult refundOrder(Long orderId){
        return AjaxResult.success(orderService.refundOrder(orderId));
    }

    @RequestMapping("/getNextOrder")
    public AjaxResult getNextOrder(Long orderId, Long shopId) {
        return AjaxResult.success(orderService.getNextOrder(orderId, shopId));
    }

    @RequestMapping("/getMessageCount")
    public AjaxResult getMessageCount(HttpServletRequest request) {
        LoginUser loginUser = tokenService.getLoginUser(request);
        return AjaxResult.success("", wechatMessageService.getMessageCount(loginUser.getOpenId()));
    }

    @GetMapping("/coupon/list/{effectiveFlag}")
    @ApiOperation("查询用户优惠券列表")
    public TableDataInfo listUserCoupon(HttpServletRequest request, @PathVariable Boolean effectiveFlag) {
        LoginUser loginUser = tokenService.getLoginUser(request);
        if (loginUser == null) {
            throw new ServiceException("请先登录");
        }
        startPage();
        List<CouponVo> couponVos = couponUserService.listCustCoupons(loginUser.getOpenId(), effectiveFlag);
        couponRuleService.translateUseLimit(couponVos);
        return getDataTable(couponVos);
    }

    @GetMapping("/homepage/coupon-count")
    @ApiOperation("小程序首页查询用户可用优惠券数量")
    public AjaxResult getUserAvailableCouponCnt(HttpServletRequest request) {
        LoginUser loginUser = tokenService.getLoginUser(request);
        if (loginUser == null) {
            throw new ServiceException("获取信息失败，请退出后重进");
        }
        int custAvailableCouponCnt = couponUserService.getCustAvailableCouponCnt(loginUser.getOpenId());
        return AjaxResult.success(custAvailableCouponCnt);
    }

    @PostMapping("/order/coupon/fitable-count")
    @ApiOperation("小程序下单页面查询用户可用优惠券数量")
    public AjaxResult getUserAvailableCouponCnt(HttpServletRequest request, @RequestBody Order order) {
        LoginUser loginUser = tokenService.getLoginUser(request);
        if (loginUser == null) {
            throw new ServiceException("请先登录");
        }
        List<CouponVo> couponVos = couponUserService.listCustAvailableCoupon(loginUser.getOpenId(), null);
        couponUserService.resovleCouponFitable(couponVos, order);
        long fitableCount = couponVos.stream().filter(couponVo -> StringUtils.isEmpty(couponVo.getNotFitableDesc())).count();
        return AjaxResult.success(fitableCount);
    }

    @PostMapping("/order/coupon/info")
    @ApiOperation("下单页面查询用户可用优惠券信息")
    public AjaxResult listUserAvailableCoupon(HttpServletRequest request, @RequestBody Order order) {
        LoginUser loginUser = tokenService.getLoginUser(request);
        if (loginUser == null) {
            throw new ServiceException("请先登录");
        }

        List<CouponVo> couponVos = couponUserService.listCustAvailableCoupon(loginUser.getOpenId(), null);
        couponUserService.resovleCouponFitable(couponVos, order);
        couponRuleService.translateUseLimit(couponVos);

        JSONObject result = new JSONObject();

        List<CouponVo> fitableList = couponVos.stream().filter(couponVo -> StringUtils.isEmpty(couponVo.getNotFitableDesc())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(fitableList)) {
            fitableList.sort(Comparator.comparing(CouponVo::getCouponAmount).reversed());
            CouponVo couponAmountBigest = fitableList.remove(0);
            fitableList.sort(Comparator.comparing(CouponVo::getUseEndTime).thenComparing(CouponVo::getId));
            fitableList.add(0, couponAmountBigest);
            result.put("fitable", fitableList);
        }

        List<CouponVo> notFitableList = couponVos.stream().filter(couponVo -> !StringUtils.isEmpty(couponVo.getNotFitableDesc())).
                sorted(Comparator.comparing(CouponVo::getUseEndTime).thenComparing(CouponVo::getId)).collect(Collectors.toList());
        result.put("notfitable", notFitableList);
        return AjaxResult.success(result);
    }
}
