package com.soss.web.controller.coffee;

import com.alibaba.fastjson.JSONObject;
import com.soss.common.constant.Constants;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.core.domain.model.LoginUser;
import com.soss.common.utils.StringUtils;
import com.soss.framework.web.service.TokenService;
import com.soss.framework.web.service.WeixinServiceImpl;
import com.soss.system.domain.Customer;
import com.soss.system.domain.Shop;
import com.soss.system.domain.po.LocationPo;
import com.soss.system.service.ICustomerService;
import com.soss.system.service.impl.AppServiceImpl;
import com.soss.system.service.impl.OrderTakingServiceImpl;
import io.jsonwebtoken.lang.Assert;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/weixin")
@Slf4j
public class WeixinController {
    @Autowired
    private TokenService tokenService;
    @Autowired
    WeixinServiceImpl weixinService;
    @Autowired
    private AppServiceImpl appService;
    @Autowired
    private OrderTakingServiceImpl orderTakingService;
    @Autowired
    private ICustomerService customerService;

    //这个就是那个使用传code进来的接口
    @PostMapping("/login")
    public AjaxResult login(@RequestBody String body) {
        JSONObject param = JSONObject.parseObject(body);
        String code = param.getString("code");

        return AjaxResult.success(weixinService.login(code));
    }

    @PostMapping("/decrypt")
    public AjaxResult decrypt(@RequestBody String body) {
        JSONObject param = JSONObject.parseObject(body);
        String encryptedData = param.getString("encryptedData");
        String iv = param.getString("iv");
        String source = param.getString("source");
        String openId = param.getString("openId");
        String sessionKey = param.getString("session_key");
        String faceInfoId = param.getString("faceInfoId");
        Assert.isTrue(StringUtils.isNotEmpty(openId), "openId还未传递");

        AjaxResult ajax = AjaxResult.success();
        Map<String, String> decrypt = weixinService.decrypt(encryptedData, iv, source, openId, faceInfoId, sessionKey);
        ajax.put(Constants.TOKEN, decrypt.get("token"));
        ajax.put("phoneNumber", decrypt.get("phoneNumber"));
        ajax.put("customerName", decrypt.get("customerName"));
        return ajax;
    }

    @PostMapping("/refreshToken")
    public AjaxResult getRefreshToken(@RequestBody String body) {
        JSONObject param = JSONObject.parseObject(body);
        String phoneNumber = param.getString("phoneNumber");
        String token = weixinService.refresh(phoneNumber);
        AjaxResult ajax = AjaxResult.success();
        ajax.put(Constants.TOKEN, token);
        return ajax;
    }

    @GetMapping("/token/create/{custId}")
    @ApiOperation(value = "根据用户id创建token，测试用", hidden = true)
    public AjaxResult createToken4Test(@PathVariable String custId) {
        String token = weixinService.createToken4Test(custId);
        return AjaxResult.success("", token);
    }

    /**
     * 支付通知
     * 微信支付通过支付通知接口将用户支付成功消息通知给商户
     */
    @PostMapping("/native/notify")
    public String wxNotify(HttpServletRequest request) throws Exception {
        System.out.println("微信发送的回调");
        return weixinService.wxNotify(request);
    }

    /**
     * 测试支付通知
     * 微信支付通过支付通知接口将用户支付成功消息通知给商户
     */
    @GetMapping("/native/notify/test/{orderNo}")
    public String wxNotifyTest(@PathVariable String orderNo) throws Exception {
        System.out.println("微信发送的回调");
        return weixinService.wxNotifyTest(orderNo);
    }

    @RequestMapping("/v2/getShop")
    public AjaxResult getShopV2(HttpServletRequest request, @RequestParam(required = false) String lng, @RequestParam(required = false) String lat) throws ParseException {
        LoginUser loginUser = tokenService.getLoginUser(request);
        boolean testFlag = false;
        if (loginUser != null) {
            Customer customer = customerService.selectCustById(loginUser.getOpenId());
            if (customer != null) {
                testFlag = customer.getTestFlag();
            }
        }
        return AjaxResult.success(appService.getShop(loginUser, lng, lat, testFlag));
    }

    @RequestMapping("/v2/getLocationShops")
    public AjaxResult getSameLocationShops(HttpServletRequest request, @RequestBody LocationPo locationPo) throws ParseException {
        LoginUser loginUser = tokenService.getLoginUser(request);
        boolean testFlag = false;
        if (loginUser != null) {
            Customer customer = customerService.selectCustById(loginUser.getOpenId());
            if (customer != null) {
                testFlag = customer.getTestFlag();
            }
        }
        return AjaxResult.success(appService.getSameLocationShops(loginUser, locationPo, testFlag));
    }

    @RequestMapping("/getShop")
    public AjaxResult getShop(HttpServletRequest request, @RequestParam(required = false) String lng, @RequestParam(required = false) String lat) {
        LoginUser loginUser = tokenService.getLoginUser(request);
        Shop shop;
        if (StringUtils.isEmpty(lng) || StringUtils.isEmpty(lat)) {
            shop = appService.getShop(loginUser);
        } else {
            Customer customer = customerService.selectCustById(loginUser.getOpenId());
            shop = appService.getShop(lng, lat, customer.getTestFlag());
        }
        return AjaxResult.success(shop);
    }

    @RequestMapping("/getArea")
    public AjaxResult getArea(HttpServletRequest request, @RequestParam(required = false) String lng, @RequestParam(required = false) String lat) throws ParseException {
        LoginUser loginUser = tokenService.getLoginUser(request);
        List<JSONObject> area;
        if (loginUser == null || StringUtils.isEmpty(loginUser.getOpenId())) {
            area = weixinService.getArea(lng, lat, false);
        } else {
            Customer customer = customerService.selectCustById(loginUser.getOpenId());
            area = weixinService.getArea(lng, lat, customer.getTestFlag());
        }
        return AjaxResult.success(area);
    }

    @GetMapping(value = "/infoByShop")
    public AjaxResult infoByShop(Long shopId) {
        return AjaxResult.success(orderTakingService.getInfoByShop(shopId));
    }

    /**
     * 退款回调
     *
     * @param xmlData
     * @return
     */
    @RequestMapping(method = RequestMethod.POST, value = "/refundNotify")
    public String refundNotify(@RequestBody String xmlData) {
        log.info("微信退款回调数据为；【{}】", xmlData);
        return weixinService.refundNotify(xmlData);
    }

/*@Autowired
private SendSmsUtil sendSmsUtil;
    @RequestMapping("/test")
    public void test(){
        sendSmsUtil.sendSms("15726637040","SMS_243650242",null);
    }*/
}
