package com.soss.system.service;

import java.util.List;

import com.soss.common.core.domain.AjaxResult;
import com.soss.system.domain.OrderRefund;
import com.soss.system.domain.vo.OrderQuery;

/**
 * 订单退款Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IOrderRefundService 
{
    /**
     * 查询订单退款
     * 
     * @param id 订单退款主键
     * @return 订单退款
     */
    public OrderRefund selectOrderRefundById(String id);

    /**
     * 查询订单退款列表
     * 
     * @param orderRefund 订单退款
     * @return 订单退款集合
     */
    public List<OrderRefund> selectOrderRefundList(OrderRefund orderRefund);

    /**
     * 新增订单退款
     * 
     * @param orderRefund 订单退款
     * @return 结果
     */
    public AjaxResult insertOrderRefund(OrderRefund orderRefund);

    /**
     * 修改订单退款
     * 
     * @param orderRefund 订单退款
     * @return 结果
     */
    public int updateOrderRefund(OrderRefund orderRefund);

    /**
     * 批量删除订单退款
     * 
     * @param ids 需要删除的订单退款主键集合
     * @return 结果
     */
    public int deleteOrderRefundByIds(String[] ids);

    /**
     * 删除订单退款信息
     * 
     * @param id 订单退款主键
     * @return 结果
     */
    public int deleteOrderRefundById(String id);

    OrderRefund getOrderRefund(String id);

    List<OrderRefund> selectOrderRefundList(OrderQuery orderQuery);
}
