package com.soss.system.service;

import java.util.List;

import com.soss.system.domain.Order;
import com.soss.system.domain.OrderSnapshot;

/**
 * 订单快照Service接口
 * 
 * @author zxq
 * @date 2022-05-22
 */
public interface IOrderSnapshotService 
{
    /**
     * 查询订单快照
     * 
     * @param orderId 订单快照主键
     * @return 订单快照
     */
    public OrderSnapshot selectOrderSnapshotByOrderId(Long orderId);

    List<OrderSnapshot> selectOrderSnapshotByOrderIds(List<Long> orderIds);

    /**
     * 查询订单快照列表
     * 
     * @param orderSnapshot 订单快照
     * @return 订单快照集合
     */
    public List<OrderSnapshot> selectOrderSnapshotList(OrderSnapshot orderSnapshot);

    /**
     * 新增订单快照
     * 
     * @param orderSnapshot 订单快照
     * @return 结果
     */
    public int insertOrderSnapshot(OrderSnapshot orderSnapshot);

    /**
     * 修改订单快照
     * 
     * @param orderSnapshot 订单快照
     * @return 结果
     */
    public int updateOrderSnapshot(OrderSnapshot orderSnapshot);

    /**
     * 批量删除订单快照
     * 
     * @param orderIds 需要删除的订单快照主键集合
     * @return 结果
     */
    public int deleteOrderSnapshotByOrderIds(String[] orderIds);

    /**
     * 删除订单快照信息
     * 
     * @param orderId 订单快照主键
     * @return 结果
     */
    public int deleteOrderSnapshotByOrderId(String orderId);

    public void saveOrderSnapshot(Order order);
}
