package com.soss.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.soss.common.exception.ServiceException;
import com.soss.common.utils.StringUtils;
import com.soss.system.domain.Goods;
import com.soss.system.domain.Machine;
import com.soss.system.domain.ShopRecommend;
import com.soss.system.jiguang.impl.JiGuangPushServiceImpl;
import com.soss.system.mapper.GoodsCategoryMapper;
import com.soss.system.mapper.MachineMapper;
import com.soss.system.mapper.OrderMapper;
import com.soss.system.mapper.ShopRecommendMapper;
import com.soss.system.service.IShopRecommendService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 推荐和今日特惠Service业务层处理
 *
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class ShopRecommendServiceImpl implements IShopRecommendService {
    @Autowired
    private ShopRecommendMapper shopRecommendMapper;
    @Autowired
    private ShopGoodsSkuServiceImpl shopGoodsSkuService;
    @Autowired
    private MachineMapper machineMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private GoodsCategoryMapper goodsCategoryMapper;
    @Autowired
    private JiGuangPushServiceImpl jiGuangPushService;

    /**
     * 查询推荐和今日特惠
     *
     * @param id 推荐和今日特惠主键
     * @return 推荐和今日特惠
     */
    @Override
    public ShopRecommend selectShopRecommendById(String id) {
        return shopRecommendMapper.selectShopRecommendById(id);
    }

    /**
     * 查询推荐和今日特惠列表
     *
     * @param shopRecommend 推荐和今日特惠
     * @return 推荐和今日特惠
     */
    @Override
    public List<Goods> selectShopRecommendList(ShopRecommend shopRecommend) {
        List<Goods> goodsList = shopRecommendMapper.selectShopRecommendGoods(shopRecommend.getShopId(), shopRecommend.getType());
        goodsList = goodsList.stream().distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(goodsList)) {
            goodsList.forEach(goods -> {
                if (!StringUtils.isEmpty(goods.getRecommendTag())) {
                    goods.setRecommendTagList(JSON.parseArray(goods.getRecommendTag(), String.class));
                }
            });
        }
        /*for (Goods goods : goodsList) {
            goods.setCategoryName(goodsCategoryMapper.selectGoodsCategoryById(String.valueOf(goods.getCategory())).getName());
            goods.setSalesVolume(orderMapper.selectSalesVolume(Long.parseLong(shopRecommend.getShopId()),goods.getId()));
        }*/
        return goodsList;
    }

    /**
     * 新增推荐和今日特惠
     *
     * @param shopRecommend 推荐和今日特惠
     * @return 结果
     */
    @Override
    public int insertShopRecommend(ShopRecommend shopRecommend) {
        if (!StringUtils.isEmpty(shopRecommend.getType()) && shopRecommend.getType().equals("2")) {
            // 特惠
            if (shopRecommend.getRecommendPrice() == null || shopRecommend.getRecommendPrice().floatValue() < 0) {
                throw new ServiceException("特惠价格不正确");
            }
            shopGoodsSkuService.updateShopGoodsSkuDiscount(shopRecommend.getShopId(), shopRecommend.getGoodsId(), shopRecommend.getRecommendPrice());
        }
        Machine machine = new Machine();
        machine.setShopId(Long.parseLong(shopRecommend.getShopId()));
        shopRecommend.setCreatedAt(new Date());
        shopRecommend.setRecDate(new Date());
        if (!CollectionUtils.isEmpty(shopRecommend.getRecommendTagList())) {
            shopRecommend.setRecommendTag(JSON.toJSONString(shopRecommend.getRecommendTagList()));
        }
        shopRecommendMapper.insertShopRecommend(shopRecommend);
        updateApplication(Long.parseLong(shopRecommend.getShopId()));
        shopRecommend.setTurn(shopRecommend.getId());
        return shopRecommendMapper.updateShopRecommend(shopRecommend);
    }

    public void updateApplication(long shopId) {
        Machine machine = new Machine();
        machine.setShopId(shopId);
        List<Machine> machines = machineMapper.selectMachineList(machine);
        if (!machines.isEmpty()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("action", "GOODS_CHANGED");
            jsonObject.put("timestamp", System.currentTimeMillis());
            int machineId = Integer.parseInt(machines.get(0).getId());
            jiGuangPushService.push(machineId, null, jsonObject);
        }
    }

    /**
     * 修改推荐和今日特惠
     *
     * @param shopRecommend 推荐和今日特惠
     * @return 结果
     */
    @Override
    public int updateShopRecommend(ShopRecommend shopRecommend) {
        return shopRecommendMapper.updateShopRecommend(shopRecommend);
    }

//    /**
//     * 批量删除推荐和今日特惠
//     *
//     * @param ids 需要删除的推荐和今日特惠主键
//     * @return 结果
//     */
//    @Override
//    public int deleteShopRecommendByIds(String[] ids) {
//        return shopRecommendMapper.deleteShopRecommendByIds(ids);
//    }
//
//    /**
//     * 删除推荐和今日特惠信息
//     *
//     * @param id 推荐和今日特惠主键
//     * @return 结果
//     */
//    @Override
//    public int deleteShopRecommendById(String id) {
//        return shopRecommendMapper.deleteShopRecommendById(id);
//    }

    @Override
    public String turn(Long shopId, String goodsId, String pointer, String type) {

        ShopRecommend shopRecommend = new ShopRecommend();
        shopRecommend.setShopId(String.valueOf(shopId));
        shopRecommend.setType(type);
        List<ShopRecommend> shopRecommends = shopRecommendMapper.selectShopRecommendList(shopRecommend);
        int size = shopRecommends.size();
        String lastGoodsId = null;
        for (int i = 0; i < size; i++) {
            ShopRecommend shopGood = shopRecommends.get(i);
            if (goodsId.equals(shopGood.getGoodsId())) {
                if ("1".equals(pointer)) {
                    int index = i - 1;
                    if (index < 0) {
                        lastGoodsId = shopGood.getGoodsId();
                    } else {
                        lastGoodsId = shopRecommends.get(index).getGoodsId();
                    }
                } else if ("2".equals(pointer)) {
                    int index = i + 1;
                    if (index >= size) {
                        lastGoodsId = shopGood.getGoodsId();
                    } else {
                        lastGoodsId = shopRecommends.get(index).getGoodsId();
                    }
                }
            }
        }
        shopRecommend.setGoodsId(goodsId);
        ShopRecommend frist = shopRecommendMapper.selectShopRecommendList(shopRecommend).get(0);
        String turn = frist.getTurn();
        shopRecommend.setGoodsId(lastGoodsId);
        ShopRecommend last = shopRecommendMapper.selectShopRecommendList(shopRecommend).get(0);
        frist.setTurn(last.getTurn());
        last.setTurn(turn);
        shopRecommendMapper.updateShopRecommend(frist);
        shopRecommendMapper.updateShopRecommend(last);
        updateApplication(Long.parseLong(shopRecommend.getShopId()));
        return null;
    }

    @Override
    public int deleteShopRecommend(String goodsId, String shopId, String type) {
        ShopRecommend shopRecommend = new ShopRecommend();
        shopRecommend.setShopId(String.valueOf(shopId));
        shopRecommend.setType(type);
        shopRecommend.setGoodsId(goodsId);
        ShopRecommend frist = shopRecommendMapper.selectShopRecommendList(shopRecommend).get(0);
        updateApplication(Long.parseLong(shopRecommend.getShopId()));
        if (!StringUtils.isEmpty(type) && type.equals("2")) {
            shopGoodsSkuService.restoreSkuDiscount(Long.parseLong(shopId), Long.parseLong(goodsId));
        }

        return shopRecommendMapper.deleteShopRecommendById(frist.getId());
    }
}
