package com.soss.system.utils;

import java.text.DecimalFormat;

/**
 * 经纬度计算距离工具类
 */
public class DistanceUtil {
    private static final double EARTH_RADIUS = 6378137;

    public static String getDistanceDesc(Double realDistance) {
        if (realDistance == null) {
            return "-1";
        }
        if (realDistance.equals(Double.MAX_VALUE)) {
            return "-1";
        }

        if (realDistance > 1000 && realDistance < 10000) {
            DecimalFormat df = new DecimalFormat("######0.0");
            return df.format(realDistance / 1000) + "km";
        } else if (realDistance >= 10000) {
            Double aDouble = realDistance / 1000;
            return aDouble.intValue() + "km";
        }

        return realDistance.intValue() + "m";
    }
    public static String getDistanceDesc(double lng1, double lat1, double lng2, double lat2) {
        double s = getRealDistance(lng1, lat1, lng2, lat2);
        return getDistanceDesc(s);
    }

    /**
     * 根据两点间经纬度坐标（double值），计算两点间距离，单位为米
     */
    public static double getRealDistance(double lng1, double lat1, double lng2, double lat2) {
        double radLat1 = Math.toRadians(lat1);
        double radLat2 = Math.toRadians(lat2);
        double a = radLat1 - radLat2;
        double b = Math.toRadians(lng1) - Math.toRadians(lng2);
        double s = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2), 2) +
                Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2), 2)));
        s *= EARTH_RADIUS;
        s = Math.round(s * 10000) / 10000;
        return s;
    }
}
