package com.soss.system.aspect;

import com.alibaba.fastjson.JSON;
import com.soss.common.utils.StringUtils;
import com.soss.common.utils.uuid.IdUtils;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

@Aspect
@Configuration
@Slf4j
public class LoggerAspect {
    // 定义切点Pointcut
    @Pointcut("execution(* com.soss.web.controller..*.*(..))")
    public void executeService() {
    }

    @Around("executeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes) ra;
        HttpServletRequest request = sra.getRequest();

        String url = request.getRequestURL().toString();
        String method = request.getMethod();

        String queryString = request.getQueryString();
        Object[] args = pjp.getArgs();

        String params = "";
        //获取请求参数集合并进行遍历拼接
        if (args.length > 0) {
            if ("POST".equals(method)||"PUT".equals(method)) {
                for (Object arg : args) {
                    if(arg instanceof HttpServletRequest || arg instanceof HttpServletResponse){
                        continue;
                    }
                    if(url.indexOf("/weixin")== -1){
                        Map map = getKeyAndValue(arg);
                        params = JSON.toJSONString(map);
                    }
                }


            } else if ("GET".equals(method)||"DELETE".equals(method)) {
                if(StringUtils.isNotEmpty(queryString)){
                    params = URLDecoder.decode(queryString, "UTF-8");

                }
            }
        }
        String s = IdUtils.randomUUID();
        log.info("请求开始 标识id:【{}】===地址【{}】,【{}】，【{}】:" ,s,url,method,params);
        // result的值就是被拦截方法的返回值
        Object result = pjp.proceed();
        log.info("请求结束 标识id:【{}】 ===返回值:【{}】" ,s,JSON.toJSON(result));
        return result;
    }

    public static Map<String, Object> getKeyAndValue(Object obj) {
        Map<String, Object> map = new HashMap<>();
        // 得到类对象
        Class userCla = obj.getClass();
        /* 得到类中的所有属性集合 */
        Field[] fs = userCla.getDeclaredFields();
        for (Field f : fs) {
            f.setAccessible(true); // 设置些属性是可以访问的
            Object val;
            try {
                val = f.get(obj);
                // 得到此属性的值
                map.put(f.getName(), val);// 设置键值
            } catch (IllegalArgumentException | IllegalAccessException e) {
               log.error("打印请求发生异常：",e);
            }

        }
        return map;
    }
}
