package com.soss.system.domain;

import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 用户信息对象 customer
 * 
 * @author zxq
 * @date 2022-05-01
 */
@Data
public class Customer extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private String id;

    /** 用户名称 */
    @Excel(name = "用户名称")
    private String userName;

    /**
     * 手机号
     */
    @Excel(name = "手机号")
    private String phone;

    /**
     * 头像图地址
     */
    @Excel(name = "头像图地址")
    private String avatarUrl;

    @ApiModelProperty("性别")
    private Boolean sex;

    @ApiModelProperty("生日")
    private Date birthday;

    /**
     * 用户来源
     */
    @Excel(name = "用户来源")
    private String soucre;

    private List<Order> cancelOrder;

    @ApiModelProperty("用户授权发送消息1：0-未授权 1-授权")
    private Boolean sendMsgFlag1;

    @ApiModelProperty("用户授权发送消息2：0-未授权 1-授权")
    private Boolean sendMsgFlag2;

    @ApiModelProperty("用户授权发送消息3：0-未授权 1-授权")
    private Boolean sendMsgFlag3;

    @ApiModelProperty("记住标识：true-记住选择")
    private Boolean rememberFlag;

    @ApiModelProperty("用户授权有效期，空则永久有效")
    private LocalDateTime flagExpireDate;

    @ApiModelProperty("测试用户标识：true-测试用户")
    private Boolean testFlag;

    private List<Order> refundOrder;
    private List<Order> normalOrder;

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("userName", getUserName())
                .append("phone", getPhone())
                .append("createTime", getCreateTime())
                .append("avatarUrl", getAvatarUrl())
                .append("soucre", getSoucre())
                .toString();
    }
}
