package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;
import java.util.List;

/**
 * 规格对象 spec
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Data
public class Spec extends BaseEntity
{
    /** 主键 */
    private long id;

    /** 规格名称 */
    @Excel(name = "规格名称")
    private String name;

    /** 规格状态1正常 2 停用 */
    @Excel(name = "规格状态1正常 2 停用")
    private int state;

    /** 是否展示选项 */
    @Excel(name = "是否展示选项")
    private Long isShow;

    /** 是否删除0否1是 */
    @Excel(name = "是否删除0否1是")
    private int isDeleted;

    /** 是否必须原料 1 否 2 是 */
    @Excel(name = "是否必须原料 1 否 2 是")
    private int isNeccessary;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    /**
     * 规格编码
     */
    @Excel(name = "规格编码")
    private String code;

    @ApiModelProperty("规格备注")
    private String remark;

    @ApiModelProperty("原料备注")
    private String materialRemark;

    private List<SpecRule> specRules;

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("name", getName())
                .append("state", getState())
                .append("isShow", getIsShow())
                .append("isDeleted", getIsDeleted())
                .append("isNeccessary", getIsNeccessary())
                .append("createdAt", getCreatedAt())
                .append("updatedAt", getUpdatedAt())
                .append("code", getCode())
                .toString();
    }
}
