package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 规格选项对象 spec_rule
 *
 * @author zxq
 * @date 2022-04-28
 */
public class SpecRule extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private long id;

    /** 选项名称 */
    @Excel(name = "选项名称")
    private String name;

    /** 规格ID */
    @Excel(name = "规格ID")
    private long specId;

    /** 此规格价格 */
    @Excel(name = "此规格价格")
    private BigDecimal amount;

    /** 顺序 */
    @Excel(name = "顺序")
    private String turn;

    /** 是否推荐 1 否 2 是 */
    @Excel(name = "是否推荐 1 否 2 是")
    private String isRecommend;

    /** 是否默认0否1是 */
    @Excel(name = "是否默认0否1是")
    private Long isDefault;

    /** 是否删除0 否1是 */
    @Excel(name = "是否删除0 否1是")
    private int isDeleted;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    private Integer state;

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    private List<SpecRuleMaterial> specRuleMaterials;

    public List<SpecRuleMaterial> getSpecRuleMaterials() {
        return specRuleMaterials;
    }

    public void setSpecRuleMaterials(List<SpecRuleMaterial> specRuleMaterials) {
        this.specRuleMaterials = specRuleMaterials;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setSpecId(long specId) {
        this.specId = specId;
    }

    public long getSpecId() {
        return specId;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setTurn(String turn) {
        this.turn = turn;
    }

    public String getTurn() {
        return turn;
    }

    public void setIsRecommend(String isRecommend) {
        this.isRecommend = isRecommend;
    }

    public String getIsRecommend() {
        return isRecommend;
    }

    public void setIsDefault(Long isDefault) {
        this.isDefault = isDefault;
    }

    public Long getIsDefault() {
        return isDefault;
    }

    public void setIsDeleted(int isDeleted) {
        this.isDeleted = isDeleted;
    }

    public int getIsDeleted() {
        return isDeleted;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return createdAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() {
        return updatedAt;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("name", getName())
                .append("specId", getSpecId())
                .append("amount", getAmount())
                .append("turn", getTurn())
                .append("isRecommend", getIsRecommend())
                .append("isDefault", getIsDefault())
                .append("isDeleted", getIsDeleted())
                .append("createdAt", getCreatedAt())
                .append("updatedAt", getUpdatedAt())
                .toString();
    }
}
