package com.soss.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@ApiModel("轮播图请求类")
public class BannerVo {
    /** 主键 */
    private Long id;
    /**
     * 图片url
     */
    private String image;
    /**
     * 页面url
     */
    private String page;
    /**
     * 类型：1-小程序，2-KDS，3-点单屏
     */
    private Integer type;
    /**
     * 目标：1-小程序首页，2-小程序我的，0-其它
     */
    private Integer target;
    /**
     * 排序
     */
    private Integer sort;

    @ApiModelProperty("可用省份列表，全国通用传 [0]")
    private String provinceStr;
    private String[] province;

    @ApiModelProperty("可用城市列表")
    private String cityStr;
    private String[] city;

    @ApiModelProperty("可用区域列表")
    private String areaStr;
    private String[] area;

    @ApiModelProperty("可用店铺ID列表")
    private String shopIdsStr;
    private Long[] shopIds;

    private String areaLimitDesc;
    /**
     * 状态：0-在线，1-下线
     */
    private Integer state;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdAt;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updatedAt;
}
