package com.soss.system.mapper;

import com.soss.system.domain.Goods;
import com.soss.system.domain.ShopGoods;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 店铺和商品关联Mapper接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface ShopGoodsMapper 
{
    /**
     * 查询店铺和商品关联
     * 
     * @param id 店铺和商品关联主键
     * @return 店铺和商品关联
     */
    public ShopGoods selectShopGoodsById(String id);

    /**
     * 查询店铺和商品关联列表
     * 
     * @param shopGoods 店铺和商品关联
     * @return 店铺和商品关联集合
     */
    public List<ShopGoods> selectShopGoodsList(ShopGoods shopGoods);

    /**
     * 新增店铺和商品关联
     * 
     * @param shopGoods 店铺和商品关联
     * @return 结果
     */
    public int insertShopGoods(ShopGoods shopGoods);

    /**
     * 修改店铺和商品关联
     * 
     * @param shopGoods 店铺和商品关联
     * @return 结果
     */
    public int updateShopGoods(ShopGoods shopGoods);

    /**
     * 删除店铺和商品关联
     * 
     * @param id 店铺和商品关联主键
     * @return 结果
     */
    public int deleteShopGoodsById(String id);

    /**
     * 批量删除店铺和商品关联
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteShopGoodsByIds(String[] ids);

    List<Goods> selectShopCategoryGoods(long shopId);

    List<Goods> selectShopCategoryGoodsByCategoryId(@Param("shopId") long shopId, @Param("categoryId") Long categoryId);

    void updateStatus(@Param("shopID")String shopID, @Param("goodsId") Long goodsId,@Param("machineId")  String robotID,@Param("status") String s);


    List<Goods> selectShopNoAddGoods(@Param("goodsName") String goodsName, @Param("category") String category, @Param("shopId") Long shopId);

    void deleteByShopIdGoods(@Param("shopId") Long shopId, @Param("goodsIds") List<String> goodsIds);
}
