package com.soss.system.mapper;

import java.util.List;

import com.soss.system.domain.Goods;
import com.soss.system.domain.ShopRecommend;
import com.soss.system.domain.vo.orderTaking.GoodsVo;
import org.apache.ibatis.annotations.Param;

/**
 * 推荐和今日特惠Mapper接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface ShopRecommendMapper 
{
    /**
     * 查询推荐和今日特惠
     * 
     * @param id 推荐和今日特惠主键
     * @return 推荐和今日特惠
     */
    public ShopRecommend selectShopRecommendById(String id);

    /**
     * 查询推荐和今日特惠列表
     * 
     * @param shopRecommend 推荐和今日特惠
     * @return 推荐和今日特惠集合
     */
    public List<ShopRecommend> selectShopRecommendList(ShopRecommend shopRecommend);

    /**
     * 新增推荐和今日特惠
     * 
     * @param shopRecommend 推荐和今日特惠
     * @return 结果
     */
    public int insertShopRecommend(ShopRecommend shopRecommend);

    /**
     * 修改推荐和今日特惠
     * 
     * @param shopRecommend 推荐和今日特惠
     * @return 结果
     */
    public int updateShopRecommend(ShopRecommend shopRecommend);

    /**
     * 删除推荐和今日特惠
     * 
     * @param id 推荐和今日特惠主键
     * @return 结果
     */
    public int deleteShopRecommendById(String id);

    /**
     * 批量删除推荐和今日特惠
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteShopRecommendByIds(String[] ids);

    List<GoodsVo> selectShopGoodsByTyepe(@Param("type") String s, @Param("shopId") Long shopId);

    List<Goods> selectShopRecommendGoods(@Param("shopId") String shopId,@Param("type") String type);

    void deleteByShopIdGoods(@Param("shopId") Long shopId,@Param("goodsIds") List<String> goodsIds);
}
