package com.soss.system.service;

import com.soss.system.domain.Customer;
import com.soss.system.domain.Order;
import com.soss.system.domain.vo.customer.CustomerQueryVo;
import com.soss.system.domain.vo.customer.CustomerResultVo;

import java.util.List;
import java.util.Map;

/**
 * 用户信息Service接口
 * 
 * @author zxq
 * @date 2022-05-01
 */
public interface ICustomerService 
{
    Customer selectCustById(String custId);

    /**
     * 查询用户信息
     * 
     * @param id 用户信息主键
     * @param status
     * @return 用户信息
     */
    public List<Order> selectCustomerById(String id, String status);

    /**
     * 查询用户信息列表
     * 
     * @param customer 用户信息
     * @return 用户信息集合
     */
    public List<CustomerResultVo> selectCustomerList(CustomerQueryVo customer);

    /**
     * 新增用户信息
     * 
     * @param customer 用户信息
     * @return 结果
     */
    public int insertCustomer(Customer customer);

    /**
     * 修改用户信息
     * 
     * @param customer 用户信息
     * @return 结果
     */
    public int updateCustomer(Customer customer);

    int updateSendMsgFlag(Customer customer);

    void updateCustBirthday(Customer customer);

    /**
     * 批量删除用户信息
     * 
     * @param ids 需要删除的用户信息主键集合
     * @return 结果
     */
    public int deleteCustomerByIds(Long[] ids);

    /**
     * 删除用户信息信息
     * 
     * @param id 用户信息主键
     * @return 结果
     */
    public int deleteCustomerById(Long id);

    Map<String, Object> getCustSimpleOrderStat(String custId);

    int insertCustFaceInfo(String openId, String faceInfoId);
}
