package com.soss.system.service.impl;

import java.util.List;

import com.soss.system.service.ISpecRuleMaterialService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.SpecRuleMaterialMapper;
import com.soss.system.domain.SpecRuleMaterial;

/**
 * 选项原料关联Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class SpecRuleMaterialServiceImpl implements ISpecRuleMaterialService
{
    @Autowired
    private SpecRuleMaterialMapper specRuleMaterialMapper;

    /**
     * 查询选项原料关联
     * 
     * @param id 选项原料关联主键
     * @return 选项原料关联
     */
    @Override
    public SpecRuleMaterial selectSpecRuleMaterialById(String id)
    {
        return specRuleMaterialMapper.selectSpecRuleMaterialById(id);
    }

    /**
     * 查询选项原料关联列表
     * 
     * @param specRuleMaterial 选项原料关联
     * @return 选项原料关联
     */
    @Override
    public List<SpecRuleMaterial> selectSpecRuleMaterialList(SpecRuleMaterial specRuleMaterial)
    {
        return specRuleMaterialMapper.selectSpecRuleMaterialList(specRuleMaterial);
    }

    /**
     * 新增选项原料关联
     * 
     * @param specRuleMaterial 选项原料关联
     * @return 结果
     */
    @Override
    public int insertSpecRuleMaterial(SpecRuleMaterial specRuleMaterial)
    {
        return specRuleMaterialMapper.insertSpecRuleMaterial(specRuleMaterial);
    }

    /**
     * 修改选项原料关联
     * 
     * @param specRuleMaterial 选项原料关联
     * @return 结果
     */
    @Override
    public int updateSpecRuleMaterial(SpecRuleMaterial specRuleMaterial)
    {
        return specRuleMaterialMapper.updateSpecRuleMaterial(specRuleMaterial);
    }

    /**
     * 批量删除选项原料关联
     * 
     * @param ids 需要删除的选项原料关联主键
     * @return 结果
     */
    @Override
    public int deleteSpecRuleMaterialByIds(String[] ids)
    {
        return specRuleMaterialMapper.deleteSpecRuleMaterialByIds(ids);
    }

    /**
     * 删除选项原料关联信息
     * 
     * @param id 选项原料关联主键
     * @return 结果
     */
    @Override
    public int deleteSpecRuleMaterialById(String id)
    {
        return specRuleMaterialMapper.deleteSpecRuleMaterialById(id);
    }
}
