package com.soss.web.controller.system;

import com.alibaba.fastjson.JSONObject;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.core.page.TableDataInfo;
import com.soss.common.exception.ServiceException;
import com.soss.system.domain.SysBanner;
import com.soss.system.domain.po.BannerListPo;
import com.soss.system.domain.po.BannerPo;
import com.soss.system.domain.vo.BannerVo;
import com.soss.system.service.ISysBannerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 轮播图Controller
 *
 * @author zxq
 * @date 2022-04-28
 */
@RestController
@RequestMapping("/system/banner")
public class BannerController extends BaseController {
    @Autowired
    private ISysBannerService bannerService;

    @PostMapping("/list")
    public TableDataInfo list(@RequestBody BannerListPo banner) {
        startPage();
        List<SysBanner> list = bannerService.selectBanner(banner);
        List<BannerVo> bannerVos = bannerService.copyBanner(list);
        bannerService.translateArea(bannerVos);
        return getDataTable(bannerVos);
    }

    /**
     * 创建轮播图
     *
     * @param banner
     * @return
     */
    @PostMapping("/create")
    public AjaxResult create(@RequestBody BannerPo banner) {
        try {
            return AjaxResult.success(bannerService.createBanner(banner));
        } catch (ServiceException serviceException) {
            return AjaxResult.error(99, serviceException.getMessage());
        }
    }

    /**
     * 修改轮播图
     *
     * @param banner
     * @return
     */
    @PostMapping("/update")
    public AjaxResult update(@RequestBody BannerPo banner) {
        try {
            return AjaxResult.success(bannerService.updateBanner(banner));
        } catch (ServiceException serviceException) {
            return AjaxResult.error(99, serviceException.getMessage());
        }
    }

    /**
     * 修改轮播图状态
     *
     * @param bannerId
     * @param state
     * @return
     */
    @GetMapping("/state/update")
    public AjaxResult update(@RequestParam("bannerId") Long bannerId, @RequestParam("state") Integer state) {
        try {
            return AjaxResult.success(bannerService.updateState(bannerId, state));
        } catch (ServiceException serviceException) {
            return AjaxResult.error(99, serviceException.getMessage());
        }
    }

    /**
     * 删除轮播图
     *
     * @param bannerId
     * @return
     */
    @GetMapping("/delete")
    public AjaxResult update(@RequestParam("bannerId") Long bannerId) {
        try {
            return AjaxResult.success(bannerService.delete(bannerId));
        } catch (ServiceException serviceException) {
            return AjaxResult.error(99, serviceException.getMessage());
        }
    }

    /**
     * App获取轮播图
     *
     * @param shopId
     * @return
     */
    @GetMapping("/getShopBanners")
    public AjaxResult getShopBanners(@RequestParam("shopId") Long shopId) {
        try {
            List<SysBanner> homeBanners = bannerService.getBannersByShopId(shopId, 1, 1);
            List<SysBanner> mineBanners = bannerService.getBannersByShopId(shopId, 1, 2);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("home", homeBanners);
            jsonObject.put("mine", mineBanners);
            return AjaxResult.success(jsonObject);
        } catch (ServiceException serviceException) {
            return AjaxResult.error(99, serviceException.getMessage());
        }
    }
}
