package com.soss.common.enums;

public enum CouponUserState {
    EFFECTIVE(0, "有效"),
    USED(1, "已使用"),
    EXPIRED(2, "已失效");

    private Integer state;
    private String desc;

    CouponUserState(Integer state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public Integer getState() {
        return state;
    }

    public static String getDesc(Integer state) {
        for (CouponUserState couponUserStat : CouponUserState.values()) {
            if (couponUserStat.state.equals(state)) {
                return couponUserStat.desc;
            }
        }
        return null;
    }
}
