package com.soss.common.enums;

/**
 * 消息类型枚举类
 */
public enum MessageType {
    ORDER(1, "取餐消息"),
    BONUS(2, "积分消息"),
    COUPON(3, "优惠券消息");

    private Integer type;
    private String desc;

    MessageType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public static String getDesc(Integer state) {
        for (MessageType messageType : MessageType.values()) {
            if (messageType.type.equals(state)) {
                return messageType.desc;
            }
        }
        return null;
    }
}
