package com.soss.common.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jfree.graphics2d.svg.ViewBox;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.Hashtable;

public class QRCodeUtil {

    public static void main(String[] args) {
        String qrCodeSvg = getQRCodeSvg("www.google.com", 200, 200, false);
        System.out.println(qrCodeSvg);
    }

    public static BufferedImage getQRCode(String targetUrl, int width, int height) {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<>();
        // 指定纠错等级
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        // 指定编码格式
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 0);   //设置白边
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        try {
            BitMatrix byteMatrix = qrCodeWriter.encode(targetUrl, BarcodeFormat.QR_CODE, width, height, hints);
            int crunchifyWidth = byteMatrix.getWidth();
            int crunchifyHeight = byteMatrix.getHeight();

            BufferedImage image = new BufferedImage(crunchifyWidth, crunchifyHeight, BufferedImage.TYPE_INT_RGB);
            image.createGraphics();

            Graphics2D graphics = (Graphics2D) image.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, crunchifyWidth, crunchifyHeight);
            graphics.setColor(Color.BLACK);

            for (int i = 0; i < crunchifyWidth; i++) {
                for (int j = 0; j < crunchifyHeight; j++) {
                    if (byteMatrix.get(i, j)) {
                        graphics.fillRect(i, j, 1, 1);
                    }
                }
            }
            return image;
        } catch (WriterException e) {
            throw new RuntimeException("Error getting QR Code");
        }
    }

    public static String getQRCodeSvg(String targetUrl, int width, int height, boolean withViewBox) {
        SVGGraphics2D g2 = new SVGGraphics2D(width, height);
        BufferedImage qrCodeImage = getQRCode(targetUrl, width, height);
        g2.drawImage(qrCodeImage, 0, 0, width, height, null);

        ViewBox viewBox = null;
        if (withViewBox) {
            viewBox = new ViewBox(0, 0, width, height);
        }
        return g2.getSVGElement(null, true, viewBox, null, null);
    }
}