package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户领取优惠券记录表
 * </p>
 *
 * @author caiyt
 * @since 2022-07-21
 */
@Data
@NoArgsConstructor
public class CouponUser extends BaseEntity {
    /**
     * 主键
     */
    private Integer id;

    /**
     * 用户ID
     */
    private String custId;

    /**
     * 用户名
     */
    private String custName;

    /**
     * 用户手机号
     */
    private String custPhone;

    /**
     * 关联订单
     */
    private Long orderId;
    private String orderNo;

    /**
     * 关联优惠券
     */
    private Integer couponId;

    /**
     * 领取时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime receiveTime;

    /**
     * 激活使用时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime activeTime;

    /**
     * 失效时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime expiredTime;

    /**
     * 优惠金额
     */
    private BigDecimal discount;

    /**
     * 优惠券来源 order index等等
     */
    private String source;

    /**
     * 1领取 2 发放 3赠送
     */
    private Integer type;

    /**
     * 状态 0 默认 1 已使用 2 已过期 3 已禁用
     */
    private Integer state;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updatedAt;

    public CouponUser(Integer id, Long orderId, String orderNo, Integer state) {
        this.id = id;
        this.orderId = orderId;
        this.orderNo = orderNo;
        this.state = state;
    }
}
