package com.soss.system.mapper;

import com.soss.system.domain.Spec;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 规格Mapper接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface SpecMapper 
{
    /**
     * 查询规格
     * 
     * @param id 规格主键
     * @return 规格
     */
    public Spec selectSpecById(String id);
    /**
     * 查询规格
     *
     * @param ids 规格主键
     * @return 规格
     */
    public List<Spec> selectSpecByIds(@Param("ids") List<Long> ids);

    /**
     * 查询规格列表
     * 
     * @param spec 规格
     * @return 规格集合
     */
    public List<Spec> selectSpecList(Spec spec);

    /**
     * 新增规格
     * 
     * @param spec 规格
     * @return 结果
     */
    public int insertSpec(Spec spec);

    /**
     * 修改规格
     * 
     * @param spec 规格
     * @return 结果
     */
    public int updateSpec(Spec spec);

    /**
     * 删除规格
     * 
     * @param id 规格主键
     * @return 结果
     */
    public int deleteSpecById(String id);

    /**
     * 批量删除规格
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSpecByIds(String[] ids);
}
