package com.soss.system.service;

import com.soss.common.core.domain.AjaxResult;
import com.soss.common.core.domain.model.LoginUser;
import com.soss.system.domain.Order;
import com.soss.system.domain.vo.OrderQuery;

import java.util.List;

/**
 * 订单Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IOrderService 
{
    /**
     * 查询订单
     * 
     * @param id 订单主键
     * @return 订单
     */
    Order selectOrderById(Long id);

    /**
     * 查询订单列表
     * 
     * @param order 订单
     * @return 订单集合
     */
    public List<Order> selectOrderList(OrderQuery orderQuery);

    /**
     * 新增订单
     * 
     *
     * @param request
     * @param order 订单
     * @param couponUserId
     * @return 结果
     */
    public AjaxResult insertOrder(LoginUser request, Order order, Integer couponUserId);

    void checkShopInfo(Order order);

    /**
     * 修改订单
     * 
     * @param order 订单
     * @return 结果
     */
    public int updateOrder(Order order);

    AjaxResult check(Order order);

    List<Order> getMyOrder(String openId);

    void wrapperOrder(List<Order> orders, boolean snapshotFlag);

    void wrapperOrderDetailForApplet(Order order);

    int cancel(Long orderId);
}
