package com.soss.system.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.soss.system.domain.po.LocationPo;
import com.soss.system.domain.vo.LocationVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

@Component
@Slf4j
public class AreaUtil {
    //    private Map<String, Area> areaMap;
    private Map<String, String> provNameMap = new HashMap<>();
    private Map<String, String> areaOrCityFullNameMap = new HashMap<>();
    private static JSONArray DATA;

    @PostConstruct
    public void init() {
        try {
            ClassPathResource resource = new ClassPathResource("province.json");
            byte[] bdata = FileCopyUtils.copyToByteArray(resource.getInputStream());
            String data = new String(bdata, StandardCharsets.UTF_8);
            if (DATA == null) {
                DATA = JSONArray.parseArray(data);
            }
            // areaMap = buildAreaTree(areaArray);
            deepAreaTree(DATA, "", 0);
        } catch (IOException e) {
            log.error("解析区域文件出错", e);
        }
    }

    private void deepAreaTree(JSONArray areaArray, String parentName, Integer deep) {
        if (CollectionUtils.isEmpty(areaArray)) {
            return;
        }
        for (int i = 0; i < areaArray.size(); i++) {
            JSONObject area = areaArray.getJSONObject(i);
            String code = area.getString("value");
            String label = area.getString("label");
            String curLabel = parentName + label;
            if (parentName.equals("")) {
                provNameMap.put(code, curLabel);
            } else {
                areaOrCityFullNameMap.put(code, curLabel);
            }
            JSONArray children = area.getJSONArray("children");
            deepAreaTree(children, curLabel, deep + 1);
        }
    }

    public String getProvNameByCode(String code) {
        return provNameMap.get(code);
    }

    public String getCityOrAreaNameByCode(String code) {
        return areaOrCityFullNameMap.get(code);
    }

    public LocationVo translateLocation(LocationPo locationPo) {
        if (locationPo == null || locationPo.isEmpty()) {
            return null;
        }
        for (int i = 0; i < DATA.size(); i++) {
            JSONObject provinceObj = DATA.getJSONObject(i);
            String provinceName = provinceObj.getString("label");
            String provinceCode = provinceObj.getString("value");
            if (!provinceName.equals(locationPo.getProvince())) {
                continue;
            }
            JSONArray cityArray = provinceObj.getJSONArray("children");
            for (int j = 0; j < cityArray.size(); j++) {
                JSONObject cityObj = cityArray.getJSONObject(j);
                String cityName = cityObj.getString("label");
                String cityCode = cityObj.getString("value");
                if (!cityName.equals(locationPo.getCity())) {
                    continue;
                }

                JSONArray areaArray = cityObj.getJSONArray("children");
                for (int k = 0; k < areaArray.size(); k++) {
                    JSONObject areaObj = areaArray.getJSONObject(k);
                    String areaName = areaObj.getString("label");
                    String areaCode = areaObj.getString("value");
                    if (!areaName.equals(locationPo.getArea())) {
                        continue;
                    }
                    LocationVo locationVo = new LocationVo();
                    locationVo.setProvinceCode(provinceCode);
                    locationVo.setCityCode(cityCode);
                    locationVo.setAreaCode(areaCode);
                    return locationVo;
                }
            }
        }
        return null;
    }


    /*private Map<String, Area> buildAreaTree(JSONArray areaArray) {
        if (CollectionUtils.isEmpty(areaArray)) {
            return null;
        }
        Map<String, Area> areaMap = new HashMap<>();
        for (int i = 0; i < areaArray.size(); i++) {
            JSONObject area = areaArray.getJSONObject(i);
            String code = area.getString("value");
            String label = area.getString("label");
            JSONArray children = area.getJSONArray("children");
            areaMap.put(code, new Area(label, buildAreaTree(children)));
        }
        return areaMap;
    }

    public <T> void translateArea(List<T> ts) throws Exception {
        if (CollectionUtils.isEmpty(ts)) {
            return;
        }
        Map<String, Field> tfdMap = ReflectUtil.getFields(ts.get(0));
        for (T t : ts) {
            Map<String, Area> cityMap = translate(t, "province", "provinceDesc", tfdMap, areaMap);
            if (cityMap == null) continue;
            Map<String, Area> areaMap = translate(t, "city", "cityDesc", tfdMap, cityMap);
            if (areaMap == null) continue;
            translate(t, "area", "areaDesc", tfdMap, areaMap);
        }
    }

    private <T> Map<String, Area> translate(T t, String codeFieldName, String descFieldName,
                                            Map<String, Field> tfdMap, Map<String, Area> areaMap) throws Exception {
        if (CollectionUtils.isEmpty(areaMap)) {
            return null;
        }
        Field provField = tfdMap.get(codeFieldName);
        Field provDescField = tfdMap.get(descFieldName);
        if (provField == null || provDescField == null) {
            return null;
        }
        ReflectUtil.accessField(provField, provDescField);
        String province = (String) provField.get(t);
        if (!StringUtils.hasText(province)) {
            return null;
        }
        Area area = areaMap.get(province);
        if (area == null) return null;
        provDescField.set(t, area.getLabel());
        return area.getChildren();
    }

    @Data
    @AllArgsConstructor
    class Area {
        private String label;
        private Map<String, Area> children;
    }*/
}
