import request from "@/utils/request";


// 机型组件
export function getModelComponentList(id) {
  return request({
    url: "/v1/model/component?model_id=" + id  + "&limit=1000",
    method: "get",
  });
}


// 机型列表
export function getModelList() {
  return request({
    url: "/v1/machine/model",
    method: "get",
  });
}

// 机型组件类型列表
export function getComponentList() {
  return request({
    url: "/v1/component",
    method: "get",
  });
}

// 新增机型组件
export function addComponent(data) {
  return request({
    url: "/v1/add/model/component",
    method: "post",
    data: data,
  });
}

// 删除机型组件
export function delComponent(id,model_id) {
  return request({
    url: "/v1/del/model/component?id=" + id  + "&model_id="+model_id,
    method: "get"
  });
}

// 新增机型组件属性
export function addComponentProperty(data) {
  return request({
    url: "/v1/add/model/component/property",
    method: "post",
    data: data,
  });
}


// 机型组件属性列表
export function getComponentPropertyList(model_id,ros_code) {
  return request({
    url: "/v1/model/component/property?model_id=" + model_id  + "&ros_code="+ros_code,
    method: "get",
  });
}








