import request from "@/utils/request";

// 查询列表
export function listClass(query) {
  return request({
    url: "/system/category/list",
    method: "get",
    params: query,
  });
}
// 查询列表
export function getList(query) {
  return request({
    url: "/system/category/getList",
    method: "get",
    params: query,
  });
}

// 查询详细
export function getClass(id) {
  return request({
    url: "/system/category/" + id,
    method: "get",
  });
}

// 新增
export function addClass(data) {
  return request({
    url: "/system/category",
    method: "post",
    data: data,
  });
}

// 修改
export function updateClass(data) {
  return request({
    url: "/system/category",
    method: "put",
    data: data,
  });
}

// 删除
export function delClass(id) {
  return request({
    url: "/system/category/" + id,
    method: "delete",
  });
}

// 查询排序列表
export function turnList(query) {
  return request({
    url: "/system/category/turnOrder",
    method: "get",
    params: query,
  });
}
