import request from "@/utils/request";

// 查询列表
export function listSpu(query) {
  return request({
    url: "/system/goods/list",
    method: "get",
    params: query,
  });
}

// 查询详细
export function getSpu(id) {
  return request({
    url: "/system/goods/" + id,
    method: "get",
  });
}

// 新增
export function addSpu(data) {
  return request({
    url: "/system/goods",
    method: "post",
    data: data,
  });
}

// 修改
export function updateSpu(data) {
  return request({
    url: "/system/goods",
    method: "put",
    data: data,
  });
}

// 删除
export function delSpu(id) {
  return request({
    url: "/system/goods/remove?goodsId=" + id + "&boo=true",
    method: "delete",
  });
}

// 上架
export function putShop(params) {
  return request({
    url: "/system/goods/putShop",
    method: "get",
    params,
  });
}

// 下架
export function offShop(params) {
  return request({
    url: "/system/goods/offShop",
    method: "get",
    params,
  });
}


// 店铺添加商品查询列表
export function goodslist(query) {
  return request({
    url: "/system/shop/goodslist",
    method: "get",
    params: query,
  });
}

