import request from '@/utils/request'

// 查询规格列表
export function listSpecs(query) {
  return request({
    url: '/system/spec/list',
    method: 'get',
    params: query
  })
}

// 查询规格详细
export function getSpecs(id) {
  return request({
    url: '/system/spec/' + id,
    method: 'get'
  })
}

// 新增规格
export function addSpecs(data) {
  return request({
    url: '/system/spec',
    method: 'post',
    data: data
  })
}

// 修改规格
export function updateSpecs(data) {
  return request({
    url: '/system/spec',
    method: 'put',
    data: data
  })
}

// 删除规格
export function delSpecs(id) {
  return request({
    url: '/system/spec/' + id,
    method: 'delete'
  })
}
