import request from "@/utils/request";

// 查询列表
export function listCoupon(data) {
  return request({
    url: "/coupon/list",
    method: "post",
    data: data,
  });
}


// 新增
export function addCoupon(data) {
  return request({
    url: "/coupon",
    method: "put",
    data: data,
  });
}

// 修改
export function updateCoupon(data) {
  return request({
    url: "/coupon",
    method: "post",
    data: data,
  });
}

// 删除
export function delCoupon(id) {
  return request({
    url: "/coupon/" + id,
    method: "delete",
  });
}

// 下架
export function offlineCoupon(id) {
  return request({
    url: "/coupon/offline/" + id,
    method: "get",
  });
}

// 上架
export function onlineCoupon(id) {
  return request({
    url: "/coupon/online/" + id,
    method: "get",
  });
}

// 用户领取优惠券列表
export function getCouponInfoList(data) {
  return request({
    url: "/coupon-user/list",
    method: "post",
    data: data,
  });
}

// 用户下单总量和下单总金额
export function getCusOrderNum(custId) {
  return request({
    url: "/system/customer/order-simple-stat/" + custId,
    method: "get",
  });
}

// 获取优惠券详情
export function getCouponDetail(id) {
  return request({
    url: "/coupon/detail/" + id,
    method: "get",
  });
}

// 获取短信模板
export function getMessageMoudle() {
  return request({
    url: "/v1/message/moudle",
    method: "get",
  });
}

// 赠送优惠券
export function giveCoupon(data) {
  return request({
    url: "/coupon-user/give",
    method: "post",
    data: data,
  });
}


