import request from "@/utils/request";

// 机器详情列表
export function getMachineList(data) {
  return request({
    url: "/v1/machine/list",
    method: "post",
    data: data,
  });
}

// 机器出产日志
export function getMachineLog(id) {
  return request({
    url: "/v1/machine/log?machine_id=" + id,
    method: "get",
  });
}

// 机器硬件日志
export function getMachineComLog(id) {
  return request({
    url: "/v1/machine/component/log?machine_id=" + id,
    method: "get",
  });
}

// 机器组件
export function getComponentList(id) {
  return request({
    url: "/v1/machine/component?machine_id=" + id,
    method: "get",
  });
}

// 咖啡菜单
export function getCoffeeList(id) {
  return request({
    url: "/v1/coffee/product/list?machine_id=" + id,
    method: "get",
  });
}

// 提交原料
export function addMaterial(data) {
  return request({
    url: "/v1/add/machine/component/material",
    method: "post",
    data: data,
  });
}

// 组件属性监控
export function getAttributeList(id) {
  return request({
    url: "/v1/machine/property/list?machine_id=" + id,
    method: "get",
  });
}

// 更新状态
export function updateState(data) {
  return request({
    url: "/v1/update/machine/state",
    method: "post",
    data: data,
  });
}

// 添加属性值
export function addProperty(data) {
  return request({
    url: "/v1/add/machine/property/value",
    method: "post",
    data: data,
  });
}

// 新增出厂日志
export function addMachineLog(data) {
  return request({
    url: "/v1/add/machine/log",
    method: "post",
    data: data,
  });
}

