import request from "@/utils/request";

// 查询店铺列表
export function listShop(query) {
  return request({
    url: "/system/shop/list",
    method: "get",
    params: query,
  });
}

// 查询店铺详细
export function getShop(id) {
  return request({
    url: "/system/shop/" + id,
    method: "get",
  });
}

// 新增店铺
export function addShop(data) {
  return request({
    url: "/system/shop",
    method: "post",
    data: data,
  });
}

// 修改店铺
export function updateShop(data) {
  return request({
    url: "/system/shop",
    method: "put",
    data: data,
  });
}

// 删除店铺
export function delShop(id) {
  return request({
    url: "/system/shop/" + id,
    method: "delete",
  });
}

// 查询店铺分类
export function getCategoryGoods(id) {
  return request({
    url: "/system/shop/getCategoryGoods?shopId=" + id,
    method: "get",
  });
}

// 店铺新增商品
export function addGoods(params) {
  return request({
    url: "/system/shop/addGoods",
    method: "get",
    params,
  });
}

// 查询机器列表
export function machine(params) {
  return request({
    url: "/system/machine/list",
    method: "get",
    params,
  });
}

// 绑定机器
export function bindMachine(params) {
  return request({
    url: "/system/machine/bindMachine",
    method: "get",
    params,
  });
}

// 绑定机器
export function unbound(params) {
  return request({
    url: "/system/machine/unbound",
    method: "get",
    params,
  });
}
// 新增推荐
export function addRecommend(data) {
  return request({
    url: "/system/recommend",
    method: "post",
    data,
  });
}
// 新增推荐
export function recommendList(params) {
  return request({
    url: "/system/recommend/list",
    method: "get",
    params,
  });
}

// 新增推荐
export function removeRecommend(params) {
  return request({
    url: "/system/recommend/remove",
    method: "get",
    params,
  });
}

// 多选框下架
export function offGoods(data) {
  return request({
    url: "/system/shop/offGoods",
    method: "post",
    data: data
  });
}

// 查询商品排序列表
export function turnList(query) {
  return request({
    url: "/system/shop/turn",
    method: "get",
    params: query,
  });
}

// 查询推荐、特惠排序列表
export function turnRecommendList(query) {
  return request({
    url: "/system/recommend/turn",
    method: "get",
    params: query,
  });
}

export function getShopCity() {
  return request({
    url: "/system/shop/getShopCity",
    method: "get",
  });
}

export function getShopAreaTree() {
  return request({
    url: "/system/shop/area/tree",
    method: "get",
  });
}

export function testFinish(shopId){
  return request({
    url: "/system/shop/test/finish/"+shopId,
    method: "get",
  });
}

export function testStart(shopId){
  return request({
    url: "/system/shop/test/start/"+shopId,
    method: "get",
  });
}

