import request from "@/utils/request";

// 查询列表
export function getCouCategoryList(pageNum,pageSize,data) {
  return request({
    url: "/coupon-category?pageNum=" + pageNum+ "&pageSize="+pageSize,
    method: "post",
    data: data,
  });
}

// 新增
export function addCouCategory(data) {
  return request({
    url: "/coupon-category",
    method: "put",
    data: data,
  });
}

// 修改
export function updateCouCategory(data) {
  return request({
    url: "/coupon-category/update",
    method: "post",
    data: data,
  });
}

// 删除
export function delCouCategory(id) {
  return request({
    url: "/coupon-category/" + id,
    method: "delete",
  });
}

// 下架
export function offlineCouCategory(id) {
  return request({
    url: "/coupon-category/offline/" + id,
    method: "get",
  });
}

// 上架
export function onlineCouCategory(id) {
  return request({
    url: "/coupon-category/online/" + id,
    method: "get",
  });
}

// 详情
export function getCouCategory(id) {
  return request({
    url: "/coupon-category/detail/" + id,
    method: "get",
  });
}

