import request from "@/utils/request";

// 查询订单列表
export function listOrder(query) {
  return request({
    url: "/order/list",
    method: "get",
    params: query,
  });
}

// 查询订单详细
export function getOrder(id) {
  return request({
    url: "/order/back/" + id,
    method: "get",
  });
}

// 新增订单
export function addOrder(data) {
  return request({
    url: "/order",
    method: "post",
    data: data,
  });
}

// 修改订单
export function updateOrder(data) {
  return request({
    url: "/order",
    method: "put",
    data: data,
  });
}

// 删除订单
export function delOrder(id) {
  return request({
    url: "/order/" + id,
    method: "delete",
  });
}

// 查询订单日志列表
export function getLogList(query) {
  return request({
    url: "/system/log/list",
    method: "get",
    params: query,
  });
}

// 退款
export function refund(data) {
  return request({
    url: "/system/refund",
    method: "post",
    data: data,
  });
}
