import request from "@/utils/request";

// 查询机型列表
export function list_machine_model(query) {
  return request({
    url: "/v1/machine/model",
    method: "get",
    params: query,
  });
}

// 可选制作步骤
export function list_step(query) {
  return request({
    url: "/v1/machine/make/step",
    method: "get",
    params: query,
  });
}

// 保存操作步骤
export function add_spec_step(data) {
  return request({
    url: '/v1/add/sku/model/risc',
    method: 'post',
    data: data
  })
}

// 获取机型规格已保存的操作步骤列表
export function list_data_spec_step(query) {
  return request({
    url: '/v1/sku/model/risc/list',
    method: 'get',
    params: query
  })
}

// 获取机型规格已保存的操作步骤列表
export function del_spec_step(query) {
  return request({
    url: '/v1/del/sku/model/risc',
    method: 'get',
    params: query
  })
}

// 查询sku list 
export function list_sku_byGoodsId(id) {
  return request({
    url: '/system/goods/sku/list/'+id,
    method: 'get'
  })
}

// 查询详细
export function getSpu(id) {
  return request({
    url: "/system/goods/" + id,
    method: "get",
  });
}
// 删除指定sku
export function del_sku_bySkuId(id) {
  return request({
    url: '/system/goods/sku/delete/'+id,
    method: 'get'
  })
}
// 恢复指定sku
export function rec_sku_bySkuId(id) {
  return request({
    url: '/system/goods/sku/recover/'+id,
    method: 'get'
  })
}