    /** 组装省市区门店数据，供回显使用 */
function buildPS(pdata){
  let province= pdata.province;
  let ps_ary = new Array();     
  if(province && province[0]==0){
    ps_ary.push(["0"]);
  }else{
    //如果 shopIds有值,其实不管哪个省市区商店有值 都用统一的方法处理 找到对应节点-找到所有最底节点-逐级找到父节点
    let t_shopIds = pdata.shopIds;
    let t_area = pdata.area;
    let t_city = pdata.city;
    let t_province = pdata.province;
    
    let child_ary = new Array();     
    //找到对应的节点
    if(t_shopIds ){
      getChildNodeData(t_shopIds,child_ary);
    }
    if(t_area ){
      getChildNodeData(t_area,child_ary);
    }
    if(t_city ){
      getChildNodeData(t_city,child_ary);
    }
    if(t_province ){
      getChildNodeData(t_province,child_ary);
    }
    //循环所有最底层子节点找到parent，生成数组；
    for(let i=0;i<child_ary.length;i++){
      let cdata_ary = new Array();    
      cdata_ary.push(child_ary[i].value); 
      getNodeData(child_ary[i],cdata_ary);
      cdata_ary.unshift("1"); 
      ps_ary.push(cdata_ary)
    }
  }
  return ps_ary;
}

let list=[];
function getChildNodeData(pval,child_ary){
  for(let i=0;i<pval.length;i++){
    //找到指定值对应的节点
    let tobj = cascadTreeData(list[1],pval[i]);
    //找到所有的最底层子节点
    getNodeList(tobj,child_ary);
  }
}

//填充所有父节点的值
function getNodeData(child,pary){
  if(child.parentObj){
    pary.unshift(child.parentObj.value);
    getNodeData(child.parentObj,pary);
  }
}
    //找到当前的值对应的节点，
function cascadTreeData(tdata,pval){  
  if(!pval || pval==null ) return null;  
  if(tdata && tdata.value && tdata.value==pval){
    return tdata;
  }else{
    let tchild = tdata.children;      
    if(tchild){          
      for(let i=0;i<tchild.length;i++){
        let titem = tchild[i];
        if(titem.value==pval){
          return titem;
        }else{
          let tobj = cascadTreeData(titem,pval);
          if(tobj) return tobj;
        }            
      }          
    }
  }     
}

//找到指定节点所有的子节点
function getNodeList(pnode,pary){
  if(pnode==null) return ;
  if(pnode.children){
      for(let i=0;i<pnode.children.length;i++){
      let titem = pnode.children[i];
      if(titem.children){
        getNodeList(titem,pary);
      }else{
        pary.push(titem);
      }       
    } 
  }else{
    pary.push(pnode);
  }
}

function getList(dataList){
  list=dataList
}

export default{
  buildPS,
  getList
}