import request from "@/utils/request";

// 查询列表
export function getBannerList(pageNum,pageSize,data) {
  return request({
    url: "/system/banner/list?pageNum=" + pageNum+ "&pageSize="+pageSize,
    method: "post",
    data: data,
  });
}

// 新增轮播图
export function addBanner(data) {
  return request({
    url: "/system/banner/create",
    method: "post",
    data: data,
  });
}

// 修改轮播图
export function updateBanner(data) {
  return request({
    url: "/system/banner/update",
    method: "post",
    data: data,
  });
}

// 删除轮播图
export function delBanner(id) {
  return request({
    url: "/system/banner/delete?bannerId="+id,
    method: "get"
  });
}

// 修改上下线状态轮播图
export function upStateBanner(id,state) {
  return request({
    url: "/system/banner/state/update?bannerId="+id+"&state="+state,
    method: "get"
  });
}







