import request from '@/utils/request'

// 查询列表
export function listSku(query) {
  return request({
    url: '/system/sku/list',
    method: 'get',
    params: query
  })
}

// 查询详细
export function getSku(id) {
  return request({
    url: '/system/sku/' + id,
    method: 'get'
  })
}

// 新增
export function addSku(data) {
  return request({
    url: '/system/sku',
    method: 'post',
    data: data
  })
}

// 修改
export function updateSku(data) {
  return request({
    url: '/system/sku',
    method: 'put',
    data: data
  })
}

// 删除
export function delSku(id) {
  return request({
    url: '/system/sku/' + id,
    method: 'delete'
  })
}
