import request from "@/utils/request";

// 查询列表
export function listMaterial(query) {
  return request({
    url: "/system/material/list",
    method: "get",
    params: query,
  });
}

// 查询详细
export function getMaterial(id) {
  return request({
    url: "/system/material/" + id,
    method: "get",
  });
}

// 新增
export function addMaterial(data) {
  return request({
    url: "/system/material",
    method: "post",
    data: data,
  });
}

// 修改
export function updateMaterial(data) {
  return request({
    url: "/system/material",
    method: "put",
    data: data,
  });
}

// 删除
export function delMaterial(parm) {
  return request({
    url: "/system/material/remove",
    method: "get",
    params: parm,
  });
}
