package com.cnooc.expert.controller.expert;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.expert.model.request.CommonFuJianListReq;
import com.cnooc.expert.controller.expert.model.request.DictNofilterListReq;
import com.cnooc.expert.controller.expert.model.request.DongJieGetReq;
import com.cnooc.expert.controller.expert.model.request.DongJiePageReq;
import com.cnooc.expert.controller.expert.model.request.ExamPaperGetReq;
import com.cnooc.expert.controller.expert.model.request.ExamQuestionListReq;
import com.cnooc.expert.controller.expert.model.request.ExamQuestionXiaoTiListReq;
import com.cnooc.expert.controller.expert.model.request.ExamRecordSaveReq;
import com.cnooc.expert.controller.expert.model.request.ExpertInfoUpdateApiReq;
import com.cnooc.expert.controller.expert.model.request.GeRenXiuJiaApplyReq;
import com.cnooc.expert.controller.expert.model.request.GeRenXiuJiaPageReq;
import com.cnooc.expert.controller.expert.model.request.KaoShiPageReq;
import com.cnooc.expert.controller.expert.model.request.PeiXunKeChengKeJieFuJianGetReq;
import com.cnooc.expert.controller.expert.model.request.PeiXunKeChengKeJieGetReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuByOwnerPageReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuInfoGetByChouQuMaReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuPageReq;
import com.cnooc.expert.controller.expert.model.request.QingJiaJinJiApplyReq;
import com.cnooc.expert.controller.expert.model.request.QingJiaJinJiPageReq;
import com.cnooc.expert.controller.expert.model.request.TrainCourseGetInfoReq;
import com.cnooc.expert.controller.expert.model.request.TrainCourseLessonGetReq;
import com.cnooc.expert.controller.expert.model.request.TrainCourseLessonPageReq;
import com.cnooc.expert.controller.expert.model.request.TrainCoursePageReq;
import com.cnooc.expert.controller.expert.model.request.TrainExamPageReq;
import com.cnooc.expert.controller.expert.model.request.WeiGuiGetReq;
import com.cnooc.expert.controller.expert.model.request.WeiGuiJiLuPageReq;
import com.cnooc.expert.controller.expert.model.request.ZhuanJiaShenQingJiLuPageReq;
import com.cnooc.expert.controller.expert.model.response.ApproveBusinessIdGetResp;
import com.cnooc.expert.controller.expert.model.response.CityTreeNodeResp;
import com.cnooc.expert.controller.expert.model.response.DictListItemResp;
import com.cnooc.expert.controller.expert.model.response.DongJieGetResp;
import com.cnooc.expert.controller.expert.model.response.DongJiePageResp;
import com.cnooc.expert.controller.expert.model.response.ExamQuestionListResp;
import com.cnooc.expert.controller.expert.model.response.ExamQuestionXiaoTiListResp;
import com.cnooc.expert.controller.expert.model.response.ExamRecordSaveResp;
import com.cnooc.expert.controller.expert.model.response.ExpertInfoGetResp;
import com.cnooc.expert.controller.expert.model.response.GeRenXiuJiaApplyResp;
import com.cnooc.expert.controller.expert.model.response.KaoShiPageResp;
import com.cnooc.expert.controller.expert.model.response.NofilterListItemResp;
import com.cnooc.expert.controller.expert.model.response.PeiXunKeChengKeJieFuJianGetResp;
import com.cnooc.expert.controller.expert.model.response.PeiXunKeChengKeJieGetResp;
import com.cnooc.expert.controller.expert.model.response.PeiXunKeChengKeJiePageResp;
import com.cnooc.expert.controller.expert.model.response.PeiXunPageResp;
import com.cnooc.expert.controller.expert.model.response.PingBiaoXiangMuInfoGetByChouQuMaResp;
import com.cnooc.expert.controller.expert.model.response.PingBiaoXiangMuPageResp;
import com.cnooc.expert.controller.expert.model.response.PingBiaoZhuanYeTreeNodeResp;
import com.cnooc.expert.controller.expert.model.response.QingJiaJinJiApplyResp;
import com.cnooc.expert.controller.expert.model.response.SecondaryUnitListItemResp;
import com.cnooc.expert.controller.expert.model.response.TempExamPaperGetResp;
import com.cnooc.expert.controller.expert.model.response.WeiGuiGetResp;
import com.cnooc.expert.controller.expert.model.response.WeiGuiPageResp;
import com.cnooc.expert.controller.expert.model.response.ZhuanJiaShenQingJiLuPageResp;
import com.cnooc.expert.external.expert.model.request.TainLessonProgressUpdateApiReq;
import com.cnooc.expert.external.expert.model.response.CommonFuJianListApiResp;
import com.cnooc.expert.external.expert.model.response.ExamQuestionListApiResp;
import com.cnooc.expert.external.expert.model.response.ExamQuestionXiaoTiListApiResp;
import com.cnooc.expert.external.expert.model.response.ExamRecordSaveApiResp;
import com.cnooc.expert.external.expert.model.response.TainLessonProgressUpdateApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseLessonGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainExamPageApiResp;
import com.cnooc.expert.service.ExpertMockService;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@AllArgsConstructor
@RestController
@RequestMapping("/mock/expert")
public class ExpertMockController extends AbstractBaseController {

    private final ExpertMockService expertMockService;

    @PostMapping("/approve/getBusinessId")
    public ApiResult<ApproveBusinessIdGetResp> approveBusinessIdGet() {
        return ApiResult.successWithResult(expertMockService.getApproveBusinessId());
    }

    // *** 数据字典 ***

    /**
     * 民族查询列表
     *
     * @param req
     * @return
     */
    @PostMapping("/nofilter/list")
    public ApiResult<List<NofilterListItemResp>> dictNofilterList(@RequestBody @Validated DictNofilterListReq req) {
        return ApiResult.successWithResult(expertMockService.listDictNofilter(req));
    }

    /**
     * 集团二级单位列表
     *
     * @return
     */
    @PostMapping("/secondary-unit/list")
    public ApiResult<List<SecondaryUnitListItemResp>> secondaryUnitList() {
        return ApiResult.successWithResult(expertMockService.listSecondaryUnit());
    }

    /**
     * 职称列表
     *
     * @return
     */
    @PostMapping("/dict/guid3/list")
    public ApiResult<List<DictListItemResp>> dictGuiud3List() {
        return ApiResult.successWithResult(expertMockService.listDict3());
    }

    /**
     * 执业资格
     *
     * @return
     */
    @PostMapping("/dict/guid4/list")
    public ApiResult<List<DictListItemResp>> dictGuiud4List() {
        return ApiResult.successWithResult(expertMockService.listDict4());
    }

    /**
     * 学历列表
     *
     * @return
     */
    @PostMapping("/dict/guid5/list")
    public ApiResult<List<DictListItemResp>> dictGuiud5List() {
        return ApiResult.successWithResult(expertMockService.listDict5());
    }

    /**
     * 学位列表
     *
     * @return
     */
    @PostMapping("/dict/guid6/list")
    public ApiResult<List<DictListItemResp>> dictGuiud6List() {
        return ApiResult.successWithResult(expertMockService.listDict6());
    }

    /**
     * 语种
     *
     * @return
     */
    @PostMapping("/dict/guid11/list")
    public ApiResult<List<DictListItemResp>> dictGuiud11List() {
        return ApiResult.successWithResult(expertMockService.listDict11());
    }

    /**
     * 熟练程度
     *
     * @return
     */
    @PostMapping("/dict/guid12/list")
    public ApiResult<List<DictListItemResp>> dictGuiud12List() {
        return ApiResult.successWithResult(expertMockService.listDict12());
    }

    /**
     * 评标专业树
     *
     * @return
     */
    @PostMapping("/ping-biao-zhuan-ye/tree")
    public ApiResult<List<PingBiaoZhuanYeTreeNodeResp>> PingBiaoZhuanYeTree() {
        return ApiResult.successWithResult(expertMockService.treePingBiaoZhuanYe());
    }

    /**
     * 省市区树
     *
     * @return
     */
    @PostMapping("/city/tree")
    public ApiResult<List<CityTreeNodeResp>> CityTree() {
        return ApiResult.successWithResult(expertMockService.treeCity());
    }

    /**
     * 专家个人信息
     *
     * @return
     */
    @PostMapping("/info")
    public ApiResult<ExpertInfoGetResp> ExpertInfoGet() {
        return ApiResult.successWithResult(expertMockService.getExpertInfo(null));
    }

    @PostMapping("/updateAllInfo")
    public ApiResult<ExpertInfoGetResp> ExpertInfoUpdate(@RequestBody @Validated ExpertInfoUpdateApiReq req) {
        return ApiResult.successWithResult(expertMockService.updateExpetInfo(req));
    }

    /**
     * 抽取码详情
     *
     * @param req
     * @return
     */
    @PostMapping("/pingBiaoXiangMu/info-by-chouqunum")
    public ApiResult<PingBiaoXiangMuInfoGetByChouQuMaResp> pingBiaoXiangMuInfoGetByChouQuMa(@RequestBody @Validated PingBiaoXiangMuInfoGetByChouQuMaReq req) {
        return ApiResult.successWithResult(expertMockService.getPingBiaoXiangMuInfoByChouQuMa(req));
    }

    @PostMapping("/pingBiaoXiangMu/page")
    public ApiResult<BasePageResp<PingBiaoXiangMuPageResp>> pingBiaoXiangMuPage(@RequestBody @Validated PingBiaoXiangMuPageReq req) {
        return ApiResult.successWithResult(expertMockService.pagePingBiaoXiangMu(req));
    }

    // *** 请假/休假 ***

    // 紧急请假分页列表
    @PostMapping("/qing-jia/page")
    public ApiResult<BasePageResp<Object>> qingJiaJinJiPage(@RequestBody @Validated QingJiaJinJiPageReq req) {
        return ApiResult.successWithResult(expertMockService.pageJinJiQingJia(req));
    }

    // 紧急请假申请
    @PostMapping("/qing-jia/apply")
    public ApiResult<QingJiaJinJiApplyResp> qingJiaJinJiApply(@RequestBody @Validated QingJiaJinJiApplyReq req) {
        return ApiResult.successWithResult(expertMockService.applyJinJiQingJia(req));
    }


    // 个人休假分页列表
    @PostMapping("/xiu-jia/page")
    public ApiResult<BasePageResp<Object>> geRenXiuJiaPage(@RequestBody @Validated GeRenXiuJiaPageReq req) {
        return ApiResult.successWithResult(expertMockService.pageGeRenXiuJia(req));
    }

    // 个人休假申请
    @PostMapping("/xiu-jia/apply")
    public ApiResult<GeRenXiuJiaApplyResp> geRenXiuJiaApply(@RequestBody @Validated GeRenXiuJiaApplyReq req) {
        return ApiResult.successWithResult(expertMockService.applyGeRenXiuJia(req));
    }

    // *** 评标项目 ***

    // 专家的评标项目分页列表
    @PostMapping("/ping-biao-xiang-mu/by-owner/page")
    public ApiResult<BasePageResp<Object>> pingBiaoXiangMuByOwnerPage(@RequestBody @Validated PingBiaoXiangMuByOwnerPageReq req) {
        return ApiResult.successWithResult(expertMockService.pagePingBiaoXiangmuByOwner(req));
    }

    /**
     * 专家个人的申请列表
     *
     * @param req
     * @return
     */
    @PostMapping("/zhuan-jia/shen-qing-ji-lu/page")
    public ApiResult<BasePageResp<ZhuanJiaShenQingJiLuPageResp>> zhuanJiaShenQingJiLuPage(@RequestBody @Validated ZhuanJiaShenQingJiLuPageReq req) {
        return ApiResult.successWithResult(expertMockService.pageZhuanJiaShenQingJiLu(req));
    }

    // *** 违规信息/冻结信息 ***

    // 专家冻结信息分页列表
    @PostMapping("/dong-jie/page")
    public ApiResult<BasePageResp<DongJiePageResp>> dongJiePage(@RequestBody @Validated DongJiePageReq req) {
        return ApiResult.successWithResult(expertMockService.pageDongJie(req));
    }

    // 专家冻结信息详情
    @PostMapping("/dong-jie/get")
    public ApiResult<DongJieGetResp> dongjieGet(@RequestBody @Validated DongJieGetReq req) {
        return ApiResult.successWithResult(expertMockService.getDongJie(req));
    }


    // 专家违规分页列表
    @PostMapping("/wei-gui/page")
    public ApiResult<BasePageResp<WeiGuiPageResp>> weiGuiJiLuPage(@RequestBody @Validated WeiGuiJiLuPageReq req) {
        return ApiResult.successWithResult(expertMockService.pageWeiGuiList(req));
    }

    /**
     * 专家违规处理信息详情
     *
     * @param req
     * @return
     */
    @PostMapping("/wei-gui/get")
    public ApiResult<WeiGuiGetResp> weiGuiGet(@RequestBody @Validated WeiGuiGetReq req) {
        return ApiResult.successWithResult(expertMockService.getWeiGui(req));
    }

    // *** 培训 / 考试 ***

    // 课程培训

    // 培训课程分页
    @PostMapping("/train/course/page")
    public ApiResult<BasePageResp<PeiXunPageResp>> pageTrainCourse(@RequestBody @Validated TrainCoursePageReq req) {
        return ApiResult.successWithResult(expertMockService.pageTrainCourse(req));
    }

    // 培训课程详情
    @PostMapping("/train/course/get")
    public ApiResult<Object> getTrainCourseInfo(@RequestBody @Validated TrainCourseGetInfoReq req) {
        return ApiResult.successWithResult(expertMockService.getTrainCourse(req));
    }

    // 培训课程课节分页
    @PostMapping("/train/course/lesson/page")
    public ApiResult<BasePageResp<PeiXunKeChengKeJiePageResp>> pageTrainCourseLesson(@RequestBody @Validated TrainCourseLessonPageReq req) {
        return ApiResult.successWithResult(expertMockService.pageTrainCourseLesson(req));
    }

    // 培训课程课节详情
    @PostMapping("/train/course/lesson/get")
    public ApiResult<TrainCourseLessonGetApiResp> getTrainCourseLesson(@RequestBody @Validated TrainCourseLessonGetReq req) {
        TrainCourseLessonGetApiResp apiResp = expertMockService.getTrainCourseLesson(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 附件列表
    @PostMapping("/common/fu-jian/list")
    public ApiResult<List<CommonFuJianListApiResp>> listCommonFuJian(@RequestBody @Validated CommonFuJianListReq req) {
        List<CommonFuJianListApiResp> apiResp = expertMockService.listCommonFuJian(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 更新培训课节学习进度
    @PostMapping("/train/lesson-progress/update")
    public ApiResult<TainLessonProgressUpdateApiResp> updateTainLessonProgress(@RequestBody TainLessonProgressUpdateApiReq req) {
        TainLessonProgressUpdateApiResp apiResp = expertMockService.updateTainLessonProgress(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 考试分页
    @PostMapping("/train/exam/page")
    public ApiResult<BasePageResp<TrainExamPageApiResp>> trainExamPage(@RequestBody @Validated TrainExamPageReq req) {
        BasePageResp<TrainExamPageApiResp> apiResp = expertMockService.pageTrainExam(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 查询试卷信息
    @PostMapping("/train/exam/paper/get")
    public ApiResult<TempExamPaperGetResp> examPaperGet(@RequestBody @Validated ExamPaperGetReq req) {
        TempExamPaperGetResp apiResp = expertMockService.getTempExamPaper(req.getExamPaperGuid());
        return ApiResult.successWithResult(apiResp);
    }

    // 获取系统时间
    @PostMapping("/common/systemtime/get")
    public ApiResult<Long> getCommonSystemtime() {
        return ApiResult.successWithResult(expertMockService.getSystemTime());
    }

    // 保存考试记录
    @PostMapping("/train/exam/record/save")
    public ApiResult<ExamRecordSaveResp> examRecordSave(@RequestBody @Validated ExamRecordSaveReq req) {
        ExamRecordSaveResp apiResp = expertMockService.saveExamRecord(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 考试试题列表
    @PostMapping("/train/exam/question/list")
    public ApiResult<List<ExamQuestionListResp>> examQuestionList(@RequestBody @Validated ExamQuestionListReq req) {
        List<ExamQuestionListResp> apiResp = expertMockService.listExamQuestion(req.getExamPaperGuid());
        return ApiResult.successWithResult(apiResp);
    }

    // 考试试题小题列表
    @PostMapping("/train/exam/question/xiaoti/list")
    public ApiResult<List<ExamQuestionXiaoTiListResp>> examQuestionXiaoTiList(@RequestBody @Validated ExamQuestionXiaoTiListReq req) {
        List<ExamQuestionXiaoTiListResp> apiResp = expertMockService.listExamQuestionXiaoTi(req);
        return ApiResult.successWithResult(apiResp);
    }































    // 课程详情 课节 详情
    @PostMapping("/peiXun/kecheng/kejie/detail/get")
    public ApiResult<PeiXunKeChengKeJieGetResp> getPeiXunKeChengKeJie(@RequestBody @Validated PeiXunKeChengKeJieGetReq req) {
        return ApiResult.successWithResult(expertMockService.getPeiXunKeChengKeJie(req));
    }


    // 课程详情 课节 附件 详情
    @PostMapping("/peiXun/kecheng/kejie/fujian/get")
    public ApiResult<PeiXunKeChengKeJieFuJianGetResp> getPeiXunKeChengKeJieFuJian(@RequestBody @Validated PeiXunKeChengKeJieFuJianGetReq req) {
        return ApiResult.successWithResult(expertMockService.getPeiXunKeChengKeJieFuJian(req));
    }

    // 培训课程分页
    @PostMapping("/kaoShi/getKaoShiPage")
    public ApiResult<BasePageResp<KaoShiPageResp>> getKaoShiPage(@RequestBody @Validated KaoShiPageReq req) {
        return ApiResult.successWithResult(expertMockService.pageKaoShi(req));
    }


}
