package com.cnooc.expert.external.portal.service;

import com.cnooc.expert.external.common.AbstractRetrofitManager;
import com.cnooc.expert.external.common.model.response.ApiBasePageResp;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.portal.api.PortalServiceApi;
import com.cnooc.expert.external.portal.model.request.AgentNumPageApiReq;
import com.cnooc.expert.external.portal.model.request.AgentNumGetApiReq;
import com.cnooc.expert.external.portal.model.request.MessageNumGetApiReq;
import com.cnooc.expert.external.portal.model.request.MessageNumPageApiReq;
import com.cnooc.expert.external.portal.model.response.AgentNumPageApiResp;
import com.cnooc.expert.external.portal.model.response.AgentNumGetApiResp;
import com.cnooc.expert.external.portal.model.response.MessageNumGetApiResp;
import com.cnooc.expert.external.portal.model.response.MessageNumPageApiResp;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Retrofit;

import java.util.Map;

@Service
public class PortalServiceClient extends AbstractRetrofitManager {

    private final PortalServiceApi portalServiceApi;

    public PortalServiceClient(@Qualifier("retrofitPortal") Retrofit retrofit) {
        this.portalServiceApi = retrofit.create(PortalServiceApi.class);
    }

    public ApiBaseResult<AgentNumGetApiResp> getAgentNumApi(AgentNumGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<AgentNumGetApiResp>> call = portalServiceApi.agentNumGetApi(headers, req);
        return super.getResponseBody(call, "getAgentNumApi");
    }

    public ApiBaseResult<ApiBasePageResp<AgentNumPageApiResp>> pageAgentNumApi(AgentNumPageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<AgentNumPageApiResp>>> call = portalServiceApi.agentNumPageApi(headers, req);
        return super.getResponseBody(call, "pageAgentNumApi");
    }

    public ApiBaseResult<MessageNumGetApiResp> getMessageNumApi(MessageNumGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<MessageNumGetApiResp>> call = portalServiceApi.messageNumGetApi(headers, req);
        return super.getResponseBody(call, "getMessageNumApi");
    }

    public ApiBaseResult<ApiBasePageResp<MessageNumPageApiResp>> pageMessageNumApi(MessageNumPageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<MessageNumPageApiResp>>> call = portalServiceApi.messageNumPageApi(headers, req);
        return super.getResponseBody(call, "pageMessageNumApi");
    }



}
