/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.pdf;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.security.BouncyCastleDigest;
import com.itextpdf.text.pdf.security.CrlClient;
import com.itextpdf.text.pdf.security.ExternalDigest;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.OcspClient;
import com.itextpdf.text.pdf.security.OcspClientBouncyCastle;
import com.itextpdf.text.pdf.security.TSAClient;
import com.wangyin.key.server.exception.AksExceptionEnum;
import com.wangyin.key.server.exception.KeyException;
import com.wangyin.key.server.pdf.CAMakeSignature;
import com.wangyin.key.server.pdf.ImageTransparency;
import com.wangyin.key.server.pdf.PDFUtil;
import com.wangyin.key.server.pdf.TSAClientImpl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFSigner {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFSigner.class);

    public static byte[] signPDF(byte[] srcPdf, byte[] signPng, String signKeyWord, String aliasName, Certificate x509Certificate, boolean isAllSign, int page, boolean requiredTimestamp, String tsaUrl, String appId) {
        byte[] signPdf = null;
        List<Float[]> signLocateList = PDFUtil.getSignLocate(srcPdf, signKeyWord, isAllSign, page);
        if (signLocateList == null || signLocateList.isEmpty()) {
            LOGGER.error("not found sign location. signKeyWord = {}, isAll = {}, page = {}", new Object[]{signKeyWord, isAllSign, page});
            throw new KeyException(AksExceptionEnum.AKS_99_00036.getCode(), AksExceptionEnum.AKS_99_00036.getDesc());
        }
        Image signImage = PDFSigner.transparencyImage(signPng);
        Certificate[] chain = new Certificate[]{x509Certificate};
        signPdf = srcPdf;
        for (Float[] signLocate : signLocateList) {
            signPdf = PDFSigner.signPDF(signPdf, signImage, signLocate, aliasName, chain, requiredTimestamp, tsaUrl, appId, false);
        }
        return signPdf;
    }

    public static byte[] signPDF(byte[] srcPdf, byte[] signPng, String aliasName, Certificate x509Certificate, float x, float y, int page, boolean isAllSign, boolean requiredTimestamp, String tsaUrl, String appId) {
        int totalPage = PDFUtil.checkLocate(srcPdf, x, y, page);
        if (totalPage < 0) {
            LOGGER.error("sign location not valid. page = {}, x = {}, y = {}", new Object[]{page, Float.valueOf(x), Float.valueOf(y)});
            throw new KeyException(AksExceptionEnum.AKS_99_00036.getCode(), AksExceptionEnum.AKS_99_00036.getDesc());
        }
        Image signImage = PDFSigner.transparencyImage(signPng);
        Certificate[] chain = new Certificate[]{x509Certificate};
        byte[] signPdf = srcPdf;
        if (isAllSign) {
            for (int i = page; i <= totalPage; ++i) {
                Float[] tempLocate = new Float[]{Float.valueOf(x), Float.valueOf(y), Float.valueOf(x), Float.valueOf(y), Float.valueOf(i)};
                signPdf = PDFSigner.signPDF(signPdf, signImage, tempLocate, aliasName, chain, requiredTimestamp, tsaUrl, appId, true);
            }
        } else {
            Float[] signLocate = new Float[]{Float.valueOf(x), Float.valueOf(y), Float.valueOf(x), Float.valueOf(y), Float.valueOf(page)};
            signPdf = PDFSigner.signPDF(signPdf, signImage, signLocate, aliasName, chain, requiredTimestamp, tsaUrl, appId, true);
        }
        return signPdf;
    }

    public static byte[] signPDF(byte[] srcPdf, Image signPng, Float[] signLocate, String aliasName, Certificate[] chain, boolean requiredTimestamp, String tsaUrl, String appId, boolean coordinate) {
        byte[] signpdf;
        TSAClient tsaClient = null;
        if (requiredTimestamp) {
            tsaClient = PDFSigner.getTSAClient(tsaUrl, appId);
        }
        try {
            PdfReader reader = new PdfReader(srcPdf);
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            PdfStamper stamper = PdfStamper.createSignature((PdfReader)reader, (OutputStream)outBytes, (char)'\u0000', null, (boolean)true);
            PdfSignatureAppearance signAppearance = stamper.getSignatureAppearance();
            signAppearance.setSignatureGraphic(signPng);
            signAppearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC);
            float pngWith = signPng.getWidth() / 1.46f;
            float pngHight = signPng.getHeight() / 1.46f;
            Rectangle rect = coordinate ? PDFSigner.getRecByCoordinate(pngWith, pngHight, signLocate) : PDFSigner.getRec(pngWith, pngHight, signLocate);
            signAppearance.setVisibleSignature(rect, signLocate[4].intValue(), null);
            BouncyCastleDigest externalDigest = new BouncyCastleDigest();
            ArrayList<CrlClient> crlList = new ArrayList<CrlClient>();
            OcspClientBouncyCastle ocspClient = new OcspClientBouncyCastle(null);
            CAMakeSignature.signDetached(aliasName, signAppearance, (ExternalDigest)externalDigest, chain, crlList, (OcspClient)ocspClient, tsaClient, 0, MakeSignature.CryptoStandard.CMS);
            signpdf = outBytes.toByteArray();
            reader.close();
            outBytes.close();
        }
        catch (ExceptionConverter ec) {
            LOGGER.error("ExceptionConverter exception.", (Throwable)ec);
            ec.printStackTrace();
            if (ec.getException() instanceof KeyException) {
                throw new KeyException(AksExceptionEnum.AKS_99_00059.getCode(), AksExceptionEnum.AKS_99_00059.getDesc() + ec.getMessage());
            }
            throw new KeyException(AksExceptionEnum.AKS_99_00037.getCode(), AksExceptionEnum.AKS_99_00037.getDesc() + ec.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("signPDF ### sign pdf error.", (Throwable)e);
            throw new KeyException(AksExceptionEnum.AKS_99_00037.getCode(), AksExceptionEnum.AKS_99_00037.getDesc() + e.getMessage());
        }
        return signpdf;
    }

    private static TSAClient getTSAClient(String tsaUrl, String appId) {
        return new TSAClientImpl(tsaUrl, appId, "wyaks-front-api");
    }

    private static Image transparencyImage(byte[] signPng) {
        Image signImage;
        try {
            byte[] transparencyImage = ImageTransparency.transparencyImage(signPng);
            signImage = Image.getInstance((byte[])transparencyImage);
        }
        catch (Exception e) {
            LOGGER.error("signImage error.", (Throwable)e);
            throw new KeyException(AksExceptionEnum.AKS_99_00040.getCode(), AksExceptionEnum.AKS_99_00040.getDesc());
        }
        return signImage;
    }

    private static Rectangle getRec(float pngWith, float pngHight, Float[] signLocate) {
        float llx = signLocate[0].floatValue() - (pngWith - signLocate[2].floatValue()) * 0.5f;
        float lly = signLocate[1].floatValue() - (pngHight - signLocate[3].floatValue()) * 0.5f;
        float urx = signLocate[0].floatValue() + (pngWith + signLocate[2].floatValue()) * 0.5f;
        float ury = signLocate[1].floatValue() + (pngHight + signLocate[3].floatValue()) * 0.5f;
        return new Rectangle(llx, lly, urx, ury);
    }

    private static Rectangle getRecByCoordinate(float pngWith, float pngHight, Float[] signLocate) {
        float llx = signLocate[0].floatValue() - pngWith * 0.5f;
        float lly = signLocate[1].floatValue() - pngHight * 0.5f;
        float urx = signLocate[0].floatValue() + pngWith * 0.5f;
        float ury = signLocate[1].floatValue() + pngHight * 0.5f;
        return new Rectangle(llx, lly, urx, ury);
    }
}

