/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class ByteUtil {
    public static byte[] intToByteArray(int i) {
        byte[] result = new byte[4];
        for (int j = 0; j < 4; ++j) {
            result[3 - j] = (byte)(i >>> j * 8);
        }
        return result;
    }

    public static int byteToInt(byte[] b) {
        int mask = 255;
        int temp = 0;
        int n = 0;
        for (int i = 0; i < Math.min(b.length, 4); ++i) {
            n <<= 8;
            temp = b[i] & mask;
            n |= temp;
        }
        return n;
    }

    public static byte[] copy(byte[] in, int begin, int length) {
        if (null == in) {
            return null;
        }
        int len = in.length;
        if (begin < 0 || length < 0 || len < length || len < begin || len < length - begin) {
            return null;
        }
        byte[] out = new byte[length];
        System.arraycopy(in, begin, out, 0, length);
        return out;
    }

    public static byte[][] getBytes(byte[] in, int len) {
        if (in == null || in.length == 0 || len <= 0) {
            return new byte[0][];
        }
        int length = in.length;
        int count = length % len == 0 ? length / len : length / len + 1;
        byte[][] out = new byte[count][];
        int begin = 0;
        for (int i = 0; i < count; ++i) {
            if (length < len) {
                len = length;
            }
            out[i] = ByteUtil.copy(in, begin, len);
            begin += len;
            length -= len;
        }
        return out;
    }

    public static byte[] copyLast8Byte(byte[] in) {
        if (null == in || 0 == in.length) {
            return null;
        }
        byte[] out = new byte[8];
        System.arraycopy(in, in.length - 8, out, 0, 8);
        return out;
    }

    public static byte[] joinBytes(byte[] ... in) {
        int sum = 0;
        for (byte[] bytes : in) {
            sum += bytes.length;
        }
        byte[] out = new byte[sum];
        int begin = 0;
        for (byte[] bytes : in) {
            int len = bytes.length;
            System.arraycopy(bytes, 0, out, begin, len);
            begin += len;
        }
        return out;
    }

    public static char[] getChars(byte[] bytes) {
        Charset cs = Charset.forName("UTF-8");
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes);
        bb.flip();
        CharBuffer cb = cs.decode(bb);
        return cb.array();
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder sb = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (byte b : src) {
            int v = b & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                sb.append(0);
            }
            sb.append(hv);
        }
        return sb.toString();
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(ByteUtil.charToByte(hexChars[pos]) << 4 | ByteUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static String binaryToHexString(byte[] bytes) {
        String hexStr = "0123456789ABCDEF";
        StringBuilder result = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = String.valueOf(hexStr.charAt((aByte & 0xF0) >> 4));
            hex = hex + String.valueOf(hexStr.charAt(aByte & 0xF));
            result.append(hex);
        }
        return result.toString();
    }
}

