/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.util;

import com.wangyin.key.server.jni.AKSNativeCryptoService;
import com.wangyin.key.server.model.AlgEnum;
import com.wangyin.key.server.model.EncryptedDataLengthEnum;
import com.wangyin.key.server.model.ModeEnum;
import com.wangyin.key.server.model.PaddingEnum;
import com.wangyin.key.server.util.AKSConstant;
import com.wangyin.key.server.util.DatatypeConverter;
import com.wangyin.key.server.util.Preconditions;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;

public class CryptUtil {
    public static int getAlg(AlgEnum alg) {
        int algType = 0;
        if ("3DES".equals(alg.getCode())) {
            algType = 1;
        } else if ("AES128".equals(alg.getCode())) {
            algType = 2;
        } else if ("AES192".equals(alg.getCode())) {
            algType = 3;
        } else if ("AES256".equals(alg.getCode())) {
            algType = 4;
        } else if ("SM4".equals(alg.getCode())) {
            algType = 5;
        } else if ("RSA1024".equals(alg.getCode())) {
            algType = 11;
        } else if ("RSA2048".equals(alg.getCode())) {
            algType = 12;
        } else if ("SM2".equals(alg.getCode())) {
            algType = 13;
        }
        return algType;
    }

    public static int getMode(ModeEnum mode) {
        int modeType = 0;
        if ("CBC".equals(mode.getCode())) {
            modeType = 2;
        } else if ("ECB".equals(mode.getCode())) {
            modeType = 1;
        }
        return modeType;
    }

    public static int getPadding(PaddingEnum padding) {
        int padddingType = 0;
        if ("PKCS5Padding".equals(padding.getCode())) {
            padddingType = 1;
        } else if ("PKCS7Padding".equals(padding.getCode())) {
            padddingType = 2;
        } else if ("PKCS1Padding".equals(padding.getCode())) {
            padddingType = 1;
        } else if ("ANSIX923Padding".equals(padding.getCode())) {
            padddingType = 4;
        } else if ("ISO10126Padding".equals(padding.getCode())) {
            padddingType = 3;
        }
        return padddingType;
    }

    public static AlgEnum getAlgByAliasName(String aliasName) {
        String _aliasName = CryptUtil.getAlgtype(aliasName);
        if ("01".equalsIgnoreCase(_aliasName)) {
            return AlgEnum.ALG_3DES;
        }
        if ("02".equalsIgnoreCase(_aliasName)) {
            return AlgEnum.ALG_AES;
        }
        if ("03".equalsIgnoreCase(_aliasName)) {
            return AlgEnum.ALG_AES192;
        }
        if ("04".equalsIgnoreCase(_aliasName)) {
            return AlgEnum.ALG_AES256;
        }
        if ("05".equalsIgnoreCase(_aliasName)) {
            return AlgEnum.ALG_SM4;
        }
        if ("11".equalsIgnoreCase(_aliasName)) {
            return AlgEnum.ALG_RSA1024;
        }
        if ("12".equalsIgnoreCase(_aliasName)) {
            return AlgEnum.ALG_RSA2048;
        }
        if ("13".equalsIgnoreCase(_aliasName)) {
            return AlgEnum.ALG_SM2;
        }
        if ("pass".equalsIgnoreCase(_aliasName)) {
            return AlgEnum.ALG_PASS;
        }
        return AKSConstant.DEFAULT_ALG;
    }

    public static PaddingEnum getPaddingByAlg(AlgEnum alg) {
        PaddingEnum ret = AKSConstant.DEFAULT_PADDING;
        switch (alg) {
            case ALG_3DES: {
                ret = PaddingEnum.PADDING_PKCS5;
                break;
            }
            case ALG_AES: 
            case ALG_AES192: 
            case ALG_AES256: 
            case ALG_SM4: {
                ret = PaddingEnum.PADDING_PKCS7;
                break;
            }
            case ALG_RSA1024: 
            case ALG_RSA2048: 
            case ALG_SM2: {
                ret = PaddingEnum.PADDING_PKCS1;
                break;
            }
        }
        return ret;
    }

    public static PaddingEnum getPaddingByAliasName(String aliasName) {
        return CryptUtil.getPaddingByAlg(CryptUtil.getAlgByAliasName(aliasName));
    }

    public static String getAlgtype(String aliasName) {
        Preconditions.validate(aliasName);
        Preconditions.checkAliasName(aliasName);
        if (aliasName.contains("_")) {
            aliasName = aliasName.split("_")[1];
        }
        return aliasName;
    }

    public static String decodePwdDesType(String enPasswd) {
        byte[] des;
        byte[] array = DatatypeConverter.parseBase64Binary(enPasswd);
        try {
            des = AKSNativeCryptoService.crypto(false, "pwd_01_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS5, null, array);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new String(des);
    }

    public static String getAliasNameByAlg(AlgEnum alg) {
        int alg_int = CryptUtil.getAlg(alg);
        return String.format("tmp_%02d_001", alg_int);
    }

    public static int getKeyLength(AlgEnum alg) {
        if ("AES128".equals(alg.getCode())) {
            return 128;
        }
        if ("AES192".equals(alg.getCode())) {
            return 192;
        }
        if ("AES256".equals(alg.getCode())) {
            return 256;
        }
        return 128;
    }

    public static int getEncryptedDataLength(String aliasName, PaddingEnum paddingEnum, int dataLength) {
        AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
        int blockLength = EncryptedDataLengthEnum.ALG_3DES192_LEN.getLen();
        switch (alg) {
            case ALG_AES: {
                blockLength = EncryptedDataLengthEnum.ALG_AES128_LEN.getLen();
                break;
            }
            case ALG_AES192: {
                blockLength = EncryptedDataLengthEnum.ALG_AES192_LEN.getLen();
                break;
            }
            case ALG_AES256: {
                blockLength = EncryptedDataLengthEnum.ALG_AES256_LEN.getLen();
                break;
            }
            case ALG_SM4: {
                blockLength = EncryptedDataLengthEnum.ALG_SM4_LEN.getLen();
                break;
            }
        }
        if (paddingEnum.equals((Object)PaddingEnum.PADDING_NOPADDING)) {
            return dataLength / 8 / blockLength * blockLength;
        }
        return dataLength / 8 / blockLength * blockLength + blockLength;
    }

    public static Key generateKey(AlgEnum algEnum, int keyLength) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance(CryptUtil.getAlgorithmString(algEnum));
        kg.init(keyLength, new SecureRandom());
        return kg.generateKey();
    }

    public static String getAlgorithmString(AlgEnum algEnum) {
        if (algEnum == null) {
            algEnum = AlgEnum.ALG_SM4;
        }
        if (algEnum.getCode().startsWith("AES")) {
            return "AES";
        }
        return "SM4";
    }

    public static String getAlgorithmString(AlgEnum algEnum, ModeEnum modeEnum, PaddingEnum paddingEnum) {
        if (algEnum == null) {
            algEnum = AlgEnum.ALG_SM4;
        }
        if (modeEnum == null) {
            modeEnum = ModeEnum.MODE_CBC;
        }
        if (paddingEnum == null) {
            paddingEnum = PaddingEnum.PADDING_PKCS7;
        }
        return CryptUtil.getAlgorithmString(algEnum) + "/" + modeEnum.getCode() + "/" + paddingEnum.getCode();
    }
}

