/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.util;

import com.wangyin.key.server.exception.AksExceptionEnum;
import com.wangyin.key.server.exception.KeyException;
import com.wangyin.key.server.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyboardHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyboardHelper.class);

    /*
     * Enabled aggressive block sorting
     */
    public static String[] parseForKeyboard(String data) throws KeyException {
        String index;
        Preconditions.validate(data);
        String[] result = new String[2];
        if (data.length() <= 4) {
            LOGGER.warn("\u89e3\u6790\u5b89\u5168\u952e\u76d8\u6570\u636e\u5931\u8d25. data : {}", (Object)data);
            throw new KeyException(AksExceptionEnum.AKS_99_00067.getCode(), AksExceptionEnum.AKS_99_00067.getDesc() + "data.length() <= 4");
        }
        if (data.contains("_")) {
            data = data.split("_")[0];
        }
        if ((index = data.substring(0, 4)).charAt(0) == '1') {
            if (index.charAt(1) == '1') {
                result[0] = "APB_13_001";
            } else {
                if (index.charAt(1) != '0') {
                    LOGGER.warn("\u89e3\u6790\u5b89\u5168\u952e\u76d8\u6570\u636e\u5931\u8d25. index : {}", (Object)index);
                    throw new KeyException(AksExceptionEnum.AKS_99_00067.getCode(), AksExceptionEnum.AKS_99_00067.getDesc() + " index\uff1a" + index);
                }
                result[0] = "APB_12_001";
            }
        } else if (index.charAt(0) != '0') {
            LOGGER.warn("\u89e3\u6790\u5b89\u5168\u952e\u76d8\u6570\u636e\u5931\u8d25. index : {}", (Object)index);
            throw new KeyException(AksExceptionEnum.AKS_99_00067.getCode(), AksExceptionEnum.AKS_99_00067.getDesc() + " index\uff1a" + index);
        }
        result[1] = data.substring(4);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] parseForGeneralKeyboard(String data) throws KeyException {
        Preconditions.validate(data);
        if (data.contains("#")) {
            String[] result = new String[4];
            String[] dataArray = data.split("#");
            if (dataArray.length == 3) {
                result[0] = dataArray[0];
                result[1] = dataArray[1];
                result[2] = dataArray[2];
                result[3] = "hardware";
                return result;
            }
            LOGGER.warn("\u89e3\u6790General-hardware\u5b89\u5168\u952e\u76d8\u6570\u636e\u5931\u8d25. data : {}", (Object)data);
            throw new KeyException(AksExceptionEnum.AKS_99_00067.getCode(), AksExceptionEnum.AKS_99_00067.getDesc() + "dataArray.length != 3");
        }
        String[] result = new String[3];
        if (data.contains("_")) {
            data = data.split("_")[0];
        }
        if (data.length() <= 4) {
            LOGGER.warn("\u89e3\u6790General\u5b89\u5168\u952e\u76d8\u6570\u636e\u5931\u8d25. data : {}", (Object)data);
            throw new KeyException(AksExceptionEnum.AKS_99_00067.getCode(), AksExceptionEnum.AKS_99_00067.getDesc() + "data.length() <= 4");
        }
        String index = data.substring(0, 4);
        if (index.charAt(0) == '1') {
            if (index.charAt(1) == '1') {
                result[0] = "APB_13_001";
            } else {
                if (index.charAt(1) != '0') {
                    LOGGER.warn("\u89e3\u6790General\u5b89\u5168\u952e\u76d8\u6570\u636e\u5931\u8d25. index : {}", (Object)index);
                    throw new KeyException(AksExceptionEnum.AKS_99_00067.getCode(), AksExceptionEnum.AKS_99_00067.getDesc() + " index\uff1a" + index);
                }
                result[0] = "APB_12_001";
            }
        } else if (index.charAt(0) != '0') {
            LOGGER.warn("\u89e3\u6790General\u5b89\u5168\u952e\u76d8\u6570\u636e\u5931\u8d25. index : {}", (Object)index);
            throw new KeyException(AksExceptionEnum.AKS_99_00067.getCode(), AksExceptionEnum.AKS_99_00067.getDesc() + " index\uff1a" + index);
        }
        result[1] = data.substring(4);
        if (index.charAt(3) == '0') {
            result[2] = "APP";
            return result;
        }
        if (index.charAt(3) == '2') {
            result[2] = "JS";
            return result;
        }
        if (index.charAt(0) == '0') return result;
        LOGGER.warn("\u89e3\u6790General\u5b89\u5168\u952e\u76d8\u6570\u636e\u5931\u8d25. index : {}", (Object)index);
        throw new KeyException(AksExceptionEnum.AKS_99_00067.getCode(), AksExceptionEnum.AKS_99_00067.getDesc() + " index\uff1a" + index);
    }
}

