package com.cnooc.expert.controller.file;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.file.model.request.DownloadInfoReq;

import com.cnooc.expert.external.file.model.response.DownLoadInfoApiResp;
import com.cnooc.expert.service.file.FileService;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

@AllArgsConstructor
@RestController
@RequestMapping("/file")
public class FileController extends AbstractBaseController {

    private final FileService fileService;

    @PostMapping("/put/object")
    public ApiResult<List<DownLoadInfoApiResp>> filePutObject(@RequestParam("file") MultipartFile file,
                                                              @RequestParam("fileType") Integer fileType) throws IOException {
        List<DownLoadInfoApiResp> apiResp = fileService.putObject(file, fileType);
        return ApiResult.successWithResult(apiResp);
    }

    @PostMapping("/generatorDownloadInfo")
    public ApiResult<List<DownLoadInfoApiResp>> downloadInfo(@RequestBody @Validated DownloadInfoReq req) {
        List<DownLoadInfoApiResp> apiResp = fileService.downloadInfo(req.getPathId());
        return ApiResult.successWithResult(apiResp);
    }

}
