/*
 * Decompiled with CFR 0.152.
 */
package com.jd.jr.aks.security;

import com.jd.jr.aks.security.configuration.EnvMode;
import com.jd.jr.aks.security.crypto.CipherFactory;
import com.jd.jr.aks.security.crypto.Decryption;
import com.jd.jr.aks.security.exception.DecryptException;
import com.jd.jr.aks.security.exception.FailFastException;
import com.jd.jr.aks.security.monitor.MonitorMessageBuilder;
import com.jd.jr.aks.security.utils.StringsX;
import com.jd.jr.aks.security.utils.Verifys;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertiesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PropertiesLoader.class.getName());

    public static void load(Reader reader, Properties prop) throws IOException {
        Properties $prop = new Properties();
        $prop.load(reader);
        PropertiesLoader.decrypt($prop);
        prop.putAll((Map<?, ?>)$prop);
    }

    public static void load(InputStream inputStream, Properties prop) throws IOException {
        Properties $prop = new Properties();
        $prop.load(inputStream);
        PropertiesLoader.decrypt($prop);
        prop.putAll((Map<?, ?>)$prop);
    }

    static void decrypt(Properties props) {
        if (props == null || props.size() == 0) {
            return;
        }
        String mode = props.getProperty("aks.config.security.mode");
        String prefix = props.getProperty("aks.config.security.prefix");
        String suffix = props.getProperty("aks.config.security.suffix");
        EnvMode.set(mode, prefix, suffix);
        if (EnvMode.get() == EnvMode.OFF) {
            return;
        }
        ArrayList<String> fails = new ArrayList<String>(props.size());
        Decryption cipher = CipherFactory.getInstance();
        for (String key : props.stringPropertyNames()) {
            try {
                String value = props.getProperty(key);
                String $value = PropertiesLoader.decrypt(key, value, cipher);
                props.setProperty(key, $value);
            }
            catch (DecryptException e) {
                fails.add(key);
            }
        }
        if (fails.size() != 0) {
            LOGGER.error("[AKS CONFIG SECURITY:1.2.3] \u89e3\u5bc6\u5931\u8d25: " + fails);
            FailFastException fe = new FailFastException("[AKS CONFIG SECURITY:1.2.3] \u89e3\u5bc6\u5931\u8d25: " + fails);
            new MonitorMessageBuilder().className("PropertiesLoader").methodName("decrypt(P)").exception(fe).send();
            throw fe;
        }
        new MonitorMessageBuilder().className("PropertiesLoader").methodName("decrypt(P)").send();
    }

    static String decrypt(String key, String value, Decryption cipher) throws DecryptException {
        String prefix = EnvMode.prefix();
        String suffix = EnvMode.suffix();
        if (EnvMode.get() == EnvMode.OFF) {
            return value;
        }
        if (EnvMode.buildinKeys.contains(key)) {
            return value;
        }
        if (!Verifys.maybe(prefix, value, suffix)) {
            return value;
        }
        String infix = StringsX.infix(prefix, value, suffix);
        if (Verifys.notBase64(infix)) {
            if (!StringsX.isEmpty(prefix) || !StringsX.isEmpty(suffix)) {
                LOGGER.error("[AKS CONFIG SECURITY:1.2.3] \u89e3\u5bc6\u5931\u8d25: " + key);
                DecryptException de = new DecryptException("[AKS CONFIG SECURITY:1.2.3] \u89e3\u5bc6\u5931\u8d25: " + key);
                new MonitorMessageBuilder().className("PropertiesLoader").methodName("decrypt(S,S,D)").key(key).exception(de).send();
                throw de;
            }
            return value;
        }
        try {
            String $value = cipher.decrypt(infix);
            LOGGER.info("[AKS CONFIG SECURITY:1.2.3] \u89e3\u5bc6\u6210\u529f: " + key);
            new MonitorMessageBuilder().className("PropertiesLoader").key(key).methodName("decrypt(S,S,D)").send();
            return $value;
        }
        catch (DecryptException e) {
            if (!StringsX.isEmpty(prefix) || !StringsX.isEmpty(suffix)) {
                LOGGER.error("[AKS CONFIG SECURITY:1.2.3] \u89e3\u5bc6\u5931\u8d25: " + key);
                new MonitorMessageBuilder().className("PropertiesLoader").key(key).methodName("decrypt(S,S,D)").exception(e).send();
                throw e;
            }
            return value;
        }
    }
}

