/*
 * Decompiled with CFR 0.152.
 */
package com.jd.jr.aks.security.utils;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class Nets {
    private static final Set<String> trashy = new HashSet<String>(Arrays.asList("127.0.0.1", "0.0.0.0"));
    private static final String empty = "";

    public static String getIp(String other) {
        String ip = null;
        if (other != null) {
            ip = Nets.getIpBySocket(other);
        }
        if (ip == null || trashy.contains(ip)) {
            try {
                ip = Nets.getIpByInterface();
            }
            catch (SocketException e) {
                ip = empty;
            }
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIpBySocket(String ip) {
        int port = 80;
        if (ip.contains(":")) {
            String[] splits = ip.split(":");
            ip = splits[0];
            try {
                port = Integer.parseInt(splits[1]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            socket.connect(InetAddress.getByName(ip), port);
            if (socket.getLocalAddress() instanceof Inet4Address) {
                String e = socket.getLocalAddress().getHostAddress();
                return e;
            }
            String e = InetAddress.getLocalHost().getHostAddress();
            return e;
        }
        catch (IOException e) {
            String string = empty;
            return string;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    public static String getIpByInterface() throws SocketException {
        ArrayList<String> addresses = new ArrayList<String>(1);
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        if (e == null) {
            return empty;
        }
        while (e.hasMoreElements()) {
            NetworkInterface n = e.nextElement();
            if (n.isLoopback() || n.isVirtual() || n.isPointToPoint() || !n.isUp()) continue;
            Enumeration<InetAddress> ee = n.getInetAddresses();
            while (ee.hasMoreElements()) {
                InetAddress i = ee.nextElement();
                if (!(i instanceof Inet4Address) || i.isAnyLocalAddress() || !i.isSiteLocalAddress()) continue;
                addresses.add(((Inet4Address)i).getHostAddress());
            }
        }
        if (addresses.isEmpty()) {
            return empty;
        }
        StringBuilder sb = new StringBuilder();
        for (String addr : addresses) {
            sb.append(",").append(addr);
        }
        return sb.substring(1);
    }
}

